package com.github.example.pt.entity;

import jakarta.persistence.*;
import java.time.LocalDateTime;

@Entity
@Table(name = "chat_messages")
public class ChatMessage {


    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /** 聊天室 ID */
    @Column(name = "room_id", nullable = false)
    private Long roomId;

    /** 发送者用户 ID（由 Sa-Token loginId 提供） */
    @Column(name = "user_id", nullable = false)
    private Long userId;

    /** 消息内容 */
    @Column(name = "content", nullable = false, columnDefinition = "TEXT")
    private String content;

    /** 发送时间 */
    @Column(name = "created_at", nullable = false)
    private LocalDateTime createdAt;

    public ChatMessage() { }

    public ChatMessage(Long roomId, Long userId, String content, LocalDateTime createdAt) {
        this.roomId = roomId;
        this.userId = userId;
        this.content = content;
        this.createdAt = createdAt;
    }

    // 省略 getter 和 setter

    public Long getId() {
        return id;
    }

    public Long getRoomId() {
        return roomId;
    }

    public void setRoomId(Long roomId) {
        this.roomId = roomId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }
}