package com.github.example.pt.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.github.example.pt.type.LoginType;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.sql.Timestamp;

@Entity
@Table(name = "login_history",
        indexes = {
                @Index(columnList = "time")
        }
)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LoginHistory {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", nullable = false, updatable = false)
    private long id;
    @PrimaryKeyJoinColumn(name = "user_id", referencedColumnName = "id")
    @ManyToOne
    @JsonBackReference
    private User user;
    @Column(name = "time", nullable = false, updatable = false)
    private Timestamp loginTime;
    @Enumerated(EnumType.STRING)
    @Column(name = "type", nullable = false, updatable = false)
    private LoginType loginType;
    @Column(name = "ip_address", updatable = false)
    private String ipAddress;
    @Column(name = "user_agent", updatable = false)
    private String userAgent;
    @Column(name = "location", updatable = false)
    private String location;
}
