package com.github.example.pt.controller.dto.response;

import com.github.example.pt.entity.TransferHistory;
import com.github.example.pt.type.PrivacyLevel;
import lombok.Data;
import org.springframework.validation.annotation.Validated;

import java.sql.Timestamp;

@Data
@Validated
public class TransferHistoryDTO {
    private long id;
    private UserBasicResponseDTO user;
    private TorrentBasicResponseDTO torrent;
    private long left;
    private Timestamp startedAt;
    private Timestamp updatedAt;
    private long uploaded;
    private long downloaded;
    private long actualUploaded;
    private long actualDownloaded;
    private long uploadSpeed;
    private long downloadSpeed;

    public TransferHistoryDTO(TransferHistory transferHistory) {
        this.id = transferHistory.getId();
        if (transferHistory.getUser().getPrivacyLevel().ordinal() > PrivacyLevel.MEDIUM.ordinal()) {
            this.user = null;
        } else {
            this.user = new UserBasicResponseDTO(transferHistory.getUser());
        }
        this.torrent = new TorrentBasicResponseDTO(transferHistory.getTorrent());
        this.left = transferHistory.getLeft();
        this.startedAt = transferHistory.getStartedAt();
        this.updatedAt = transferHistory.getUpdatedAt();
        this.uploaded = transferHistory.getUploaded();
        this.downloaded = transferHistory.getDownloaded();
        this.actualUploaded = transferHistory.getActualUploaded();
        this.actualDownloaded = transferHistory.getActualDownloaded();
        this.uploadSpeed = transferHistory.getUploadSpeed();
        this.downloadSpeed = transferHistory.getDownloadSpeed();

    }
}
