package com.github.example.pt.controller.dto.response;

import com.github.example.pt.entity.UserGroup;
import com.github.example.pt.objects.ResponsePojo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.jetbrains.annotations.NotNull;
import org.springframework.validation.annotation.Validated;

@EqualsAndHashCode(callSuper = true)
@Data
@Validated
public class UserGroupResponseDTO extends ResponsePojo {
    private long id;
    private String slug;
    private String displayName;
    public UserGroupResponseDTO(@NotNull UserGroup userGroup){
        this.id = userGroup.getId();
        this.slug = userGroup.getSlug();
        this.displayName = userGroup.getDisplayName();
    }
}
