package com.github.example.pt.repository;

import com.github.example.pt.entity.Post;
import com.github.example.pt.entity.Topic;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

public interface PostRepository extends JpaRepository<Post, Long> {
    List<Post> findByTopicAndIsDeletedFalse(Topic topic);
    List<Post> findByUserIdAndIsDeletedFalse(Long userId);
    List<Post> findByTopicIdOrderByCreatedAtAsc(Long topicId);
}