package com.github.example.pt.service;
import com.github.example.pt.entity.ForumTag;
import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.TopicSubscription;
import com.github.example.pt.entity.User;
import com.github.example.pt.repository.ForumTagRepository;
import com.github.example.pt.repository.TopicRepository;
import com.github.example.pt.repository.TopicSubscriptionRepository;
import com.github.example.pt.repository.TopicTagRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
@Service
public class TopicTagService {

    private final TopicTagRepository topicTagRepository;
    private final TopicRepository topicRepository;
    private final ForumTagRepository forumTagRepository;

    @Autowired
    public TopicTagService(TopicTagRepository topicTagRepository,
                           TopicRepository topicRepository,
                           ForumTagRepository forumTagRepository) {
        this.topicTagRepository = topicTagRepository;
        this.topicRepository = topicRepository;
        this.forumTagRepository = forumTagRepository;
    }

    public void removeTagFromTopic(Long topicId, Long tagId) {
        // 确保topic存在
        Topic topic = topicRepository.findById(topicId)
                .orElseThrow(() -> new RuntimeException("Topic not found"));

        // 确保tag存在
        ForumTag tag = forumTagRepository.findById(tagId)
                .orElseThrow(() -> new RuntimeException("Tag not found"));

        // 从 topic_tags 表删除对应关系
        topicTagRepository.deleteByTopicIdAndTagId(topicId, tagId);
    }
}
