package com.github.example.pt.service;

import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.TopicSubscription;
import com.github.example.pt.entity.User;
import com.github.example.pt.repository.TopicSubscriptionRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class TopicSubscriptionService {

    @Autowired
    private TopicSubscriptionRepository repository;

    public void subscribe(User user, Topic topic) {
        if (!repository.existsByUser_IdAndTopic_Id(user.getId(), topic.getId())) {
            TopicSubscription subscription = new TopicSubscription(user, topic, LocalDateTime.now());
            repository.save(subscription);
        }
    }

    public void unsubscribe(Long userId, Long topicId) {
        repository.deleteByUser_IdAndTopic_Id(userId, topicId);
    }

    public List<TopicSubscription> getSubscriptions(Long userId) {
        return repository.findByUser_Id(userId);
    }

    public boolean isSubscribed(Long userId, Long topicId) {
        return repository.existsByUser_IdAndTopic_Id(userId, topicId);
    }
}