package com.github.example.pt.controller;

import cn.dev33.satoken.stp.StpUtil;
import com.github.example.pt.entity.Forum;
import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.User;
import com.github.example.pt.service.ForumService;
import com.github.example.pt.service.UserService;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/forums")
public class ForumController {

    @Autowired
    private ForumService forumService;

    @Autowired
    private UserService userService;

    @GetMapping
    public List<Forum> getAllForums() {
        return forumService.getAllForums();
    }

    @GetMapping("/{id}")
    public ResponseEntity<Forum> getForumById(@PathVariable Long id) {
        return forumService.getForumById(id)
                .map(ResponseEntity::ok)
                .orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public Forum createForum(@RequestBody Forum forum) {
        return forumService.createForum(forum);
    }

    @PutMapping("/{id}")
    public ResponseEntity<Forum> updateForum(@PathVariable Long id, @RequestBody Forum forum) {
        try {
            return ResponseEntity.ok(forumService.updateForum(id, forum));
        } catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping("/{id}")
    public ResponseEntity<Void> deleteForum(@PathVariable Long id ) {
        User user = userService.getUser(StpUtil.getLoginIdAsLong());;



        Forum forum = forumService.getForumById(id).orElseThrow(() -> new RuntimeException("forums not found"));
        Long forumuserid = forum.getUser().getId();
        if(user != null ){
            Long userid = user.getId();

            if (userid.equals(forumuserid)){
                forumService.deleteForum(id);
                return ResponseEntity.noContent().build();
            }


        }
        return ResponseEntity.status(HttpStatus.FORBIDDEN).build();

    }



}