package com.github.example.pt.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Entity
@Table(name = "settings",
        uniqueConstraints = {
                @UniqueConstraint(columnNames = {"setting_key"})
        }
)

@Data
@AllArgsConstructor
@NoArgsConstructor
public class SettingEntity {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", nullable = false, updatable = false)
    private long id;
    @Column(name = "setting_key", nullable = false)
    private String key;
    @Column(name = "setting_value", nullable = false, columnDefinition = "mediumtext")
    private String value;
}
