package com.github.example.pt;

import cn.dev33.satoken.SaManager;
import com.github.example.pt.util.PasswordHash;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import java.util.UUID;

@SpringBootApplication
@EnableCaching
@EnableTransactionManagement
@Slf4j
public class ptApplication {

    public static void main(String[] args) {
        System.out.println("Hash: " + PasswordHash.hash("testtest"));
        System.out.println(new UUID(1, 0).toString().replace("_", ""));
        System.out.println(new UUID(2, 0).toString().replace("_", ""));
        SpringApplication.run(ptApplication.class, args);
        SaManager.getConfig();
    }

}
