package com.github.example.pt.service;

import com.github.example.pt.entity.Tag;
import com.github.example.pt.repository.TagRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Locale;

@Service

public class TagService {
    @Autowired
    private TagRepository repository;

    @Nullable
    public Tag getTag(@NotNull String tagName) {
        tagName = tagName.toLowerCase(Locale.ROOT);
        return repository.findByName(tagName).orElse(null);
    }
    @Nullable
    public Tag getTag(long id){
        return repository.findById(id).orElse(null);
    }

    @NotNull
    public Tag save(@NotNull Tag tag){
        return repository.save(tag);
    }

    @NotNull
    public Iterable<Tag> getAllTags(){
        return repository.findAll();
    }
}
