/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common;

import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.BEncoder;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentParser;
import com.turn.ttorrent.common.TorrentUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Deprecated
public class TorrentCreator {
    private static final Logger logger = TorrentLoggerFactory.getLogger(TorrentCreator.class);
    public static final int DEFAULT_PIECE_LENGTH = 524288;
    private static final int HASHING_TIMEOUT_SEC = 15;
    public static int HASHING_THREADS_COUNT = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService HASHING_EXECUTOR;

    public static TorrentMetadata create(File source, URI announce, String createdBy) throws InterruptedException, IOException {
        return TorrentCreator.create(source, null, announce, createdBy);
    }

    public static TorrentMetadata create(File parent, List<File> files, URI announce, String createdBy) throws InterruptedException, IOException {
        return TorrentCreator.create(parent, files, announce, null, createdBy);
    }

    public static TorrentMetadata create(File source, List<List<URI>> announceList, String createdBy) throws InterruptedException, IOException {
        return TorrentCreator.create(source, null, null, announceList, createdBy);
    }

    public static TorrentMetadata create(File source, List<File> files, List<List<URI>> announceList, String createdBy) throws InterruptedException, IOException {
        return TorrentCreator.create(source, files, null, announceList, createdBy);
    }

    public static TorrentMetadata create(File parent, List<File> files, URI announce, List<List<URI>> announceList, String createdBy) throws InterruptedException, IOException {
        return TorrentCreator.create(parent, files, announce, announceList, createdBy, 524288);
    }

    public static TorrentMetadata create(File parent, List<File> files, URI announce, List<List<URI>> announceList, String createdBy, int pieceSize) throws InterruptedException, IOException {
        return TorrentCreator.create(parent, files, announce, announceList, createdBy, System.currentTimeMillis() / 1000L, pieceSize);
    }

    static TorrentMetadata create(File parent, List<File> files, URI announce, List<List<URI>> announceList, String createdBy, long creationTimeSecs, int pieceSize) throws InterruptedException, IOException {
        HashMap<String, BEValue> torrent = new HashMap<String, BEValue>();
        if (announce != null) {
            torrent.put("announce", new BEValue(announce.toString()));
        }
        if (announceList != null) {
            LinkedList<BEValue> tiers = new LinkedList<BEValue>();
            for (List<URI> trackers : announceList) {
                LinkedList<BEValue> tierInfo = new LinkedList<BEValue>();
                for (URI trackerURI : trackers) {
                    tierInfo.add(new BEValue(trackerURI.toString()));
                }
                tiers.add(new BEValue(tierInfo));
            }
            torrent.put("announce-list", new BEValue(tiers));
        }
        torrent.put("creation date", new BEValue(creationTimeSecs));
        torrent.put("created by", new BEValue(createdBy));
        TreeMap<String, BEValue> info = new TreeMap<String, BEValue>();
        info.put("name", new BEValue(parent.getName()));
        info.put("piece length", new BEValue(pieceSize));
        if (files == null || files.isEmpty()) {
            info.put("length", new BEValue(parent.length()));
            info.put("pieces", new BEValue(TorrentCreator.hashFile(parent, pieceSize), "ISO-8859-1"));
        } else {
            LinkedList<BEValue> fileInfo = new LinkedList<BEValue>();
            Iterator<File> iterator = files.iterator();
            while (iterator.hasNext()) {
                File file;
                HashMap<String, BEValue> fileMap = new HashMap<String, BEValue>();
                fileMap.put("length", new BEValue(file.length()));
                LinkedList<BEValue> filePath = new LinkedList<BEValue>();
                for (file = iterator.next(); file != null && !file.equals(parent); file = file.getParentFile()) {
                    filePath.addFirst(new BEValue(file.getName()));
                }
                fileMap.put("path", new BEValue(filePath));
                fileInfo.add(new BEValue(fileMap));
            }
            info.put("files", new BEValue(fileInfo));
            info.put("pieces", new BEValue(TorrentCreator.hashFiles(files, pieceSize), "ISO-8859-1"));
        }
        torrent.put("info", new BEValue(info));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BEncoder.bencode((Object)new BEValue(torrent), (OutputStream)baos);
        return new TorrentParser().parse(baos.toByteArray());
    }

    private static String hashFile(File file, int pieceSize) throws InterruptedException, IOException {
        return TorrentCreator.hashFiles(Collections.singletonList(file), pieceSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hashFiles(List<File> files, int pieceSize) throws InterruptedException, IOException {
        if (files.size() == 0) {
            return "";
        }
        LinkedList<Future<String>> results = new LinkedList<Future<String>>();
        long length = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(pieceSize);
        final AtomicInteger threadIdx = new AtomicInteger(0);
        final String firstFileName = files.get(0).getName();
        StringBuilder hashes = new StringBuilder();
        long start = System.nanoTime();
        for (File file : files) {
            logger.debug("Analyzing local data for {} with {} threads...", (Object)file.getName(), (Object)HASHING_THREADS_COUNT);
            length += file.length();
            FileInputStream fis = new FileInputStream(file);
            FileChannel channel = fis.getChannel();
            try {
                while (channel.read(buffer) > 0) {
                    if (buffer.remaining() == 0) {
                        buffer.clear();
                        final ByteBuffer data = TorrentCreator.prepareDataFromBuffer(buffer);
                        results.add(HASHING_EXECUTOR.submit(new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                Thread.currentThread().setName(String.format("%s hasher #%d", firstFileName, threadIdx.incrementAndGet()));
                                return new CallableChunkHasher(data).call();
                            }
                        }));
                    }
                    if (results.size() < HASHING_THREADS_COUNT) continue;
                    TorrentCreator.waitForHashesToCalculate(results, hashes);
                    results.clear();
                }
            }
            finally {
                channel.close();
                fis.close();
            }
        }
        if (buffer.position() > 0) {
            buffer.limit(buffer.position());
            buffer.position(0);
            ByteBuffer data = TorrentCreator.prepareDataFromBuffer(buffer);
            results.add(HASHING_EXECUTOR.submit(new CallableChunkHasher(data)));
        }
        TorrentCreator.waitForHashesToCalculate(results, hashes);
        long elapsed = System.nanoTime() - start;
        int expectedPieces = (int)Math.ceil((double)length / (double)pieceSize);
        logger.debug("Hashed {} file(s) ({} bytes) in {} pieces ({} expected) in {}ms.", new Object[]{files.size(), length, results.size(), expectedPieces, String.format("%.1f", (double)elapsed / 1000000.0)});
        return hashes.toString();
    }

    private static ByteBuffer prepareDataFromBuffer(ByteBuffer buffer) {
        ByteBuffer data = ByteBuffer.allocate(buffer.remaining());
        buffer.mark();
        data.put(buffer);
        data.clear();
        buffer.reset();
        return data;
    }

    private static void waitForHashesToCalculate(List<Future<String>> results, StringBuilder hashes) throws InterruptedException, IOException {
        try {
            for (Future<String> chunk : results) {
                hashes.append(chunk.get(15L, TimeUnit.SECONDS));
            }
        }
        catch (ExecutionException ee) {
            throw new IOException("Error while hashing the torrent data!", ee);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(String.format("very slow hashing: took more than %d seconds to calculate several pieces. Cancelling", 15));
        }
    }

    static {
        String threads = System.getenv("TTORRENT_HASHING_THREADS");
        if (threads != null) {
            try {
                int count = Integer.parseInt(threads);
                if (count > 0) {
                    HASHING_THREADS_COUNT = count;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        HASHING_EXECUTOR = Executors.newFixedThreadPool(HASHING_THREADS_COUNT, new ThreadFactory(){

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    private static class CallableChunkHasher
    implements Callable<String> {
        private final ByteBuffer data;

        CallableChunkHasher(ByteBuffer data) {
            this.data = data;
        }

        @Override
        public String call() throws UnsupportedEncodingException {
            byte[] sha1Hash = TorrentUtils.calculateSha1Hash(this.data.array());
            return new String(sha1Hash, "ISO-8859-1");
        }
    }
}

