/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common;

import java.util.concurrent.atomic.AtomicLong;

public class TorrentStatistic {
    private final AtomicLong myUploadedBytes;
    private final AtomicLong myDownloadedBytes;
    private final AtomicLong myLeftBytes;

    public TorrentStatistic() {
        this.myDownloadedBytes = new AtomicLong();
        this.myUploadedBytes = new AtomicLong();
        this.myLeftBytes = new AtomicLong();
    }

    public TorrentStatistic(TorrentStatistic torrentStatistic) {
        this.myDownloadedBytes = new AtomicLong(torrentStatistic.getDownloadedBytes());
        this.myUploadedBytes = new AtomicLong(torrentStatistic.getUploadedBytes());
        this.myLeftBytes = new AtomicLong(torrentStatistic.getLeftBytes());
    }

    public long getUploadedBytes() {
        return this.myUploadedBytes.get();
    }

    public long getDownloadedBytes() {
        return this.myDownloadedBytes.get();
    }

    public long getLeftBytes() {
        return this.myLeftBytes.get();
    }

    public void addUploaded(long delta) {
        this.myUploadedBytes.addAndGet(delta);
    }

    public void addDownloaded(long delta) {
        this.myDownloadedBytes.addAndGet(delta);
    }

    public void addLeft(long delta) {
        this.myLeftBytes.addAndGet(delta);
    }

    public void setLeft(long value) {
        this.myLeftBytes.set(value);
    }

    public void setUploaded(long value) {
        this.myUploadedBytes.set(value);
    }

    public void setDownloaded(long value) {
        this.myDownloadedBytes.set(value);
    }

    public long getPercentageDownloaded() {
        long downloadedBytes = this.getDownloadedBytes();
        long totalBytes = this.getTotalBytes();
        return downloadedBytes * 100L / totalBytes;
    }

    public long getTotalBytes() {
        return this.getDownloadedBytes() + this.getLeftBytes();
    }
}

