/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.strategy;

import com.turn.ttorrent.client.Piece;
import com.turn.ttorrent.client.peer.SharingPeer;
import com.turn.ttorrent.client.strategy.EndGameStrategy;
import com.turn.ttorrent.client.strategy.RequestsCollection;
import com.turn.ttorrent.client.strategy.RequestsCollectionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class EndGameStrategyImpl
implements EndGameStrategy {
    private static final Random RANDOM = new Random();
    private final int peersPerPiece;

    public EndGameStrategyImpl(int peersPerPiece) {
        this.peersPerPiece = peersPerPiece;
    }

    @Override
    public RequestsCollection collectRequests(Piece[] allPieces, List<SharingPeer> connectedPeers) {
        ArrayList<SharingPeer> sorted = new ArrayList<SharingPeer>(connectedPeers);
        HashMap<Piece, List<SharingPeer>> selectedPieces = new HashMap<Piece, List<SharingPeer>>();
        Collections.sort(sorted, new Comparator<SharingPeer>(){

            @Override
            public int compare(SharingPeer o1, SharingPeer o2) {
                return Integer.valueOf(o1.getDownloadedPiecesCount()).compareTo(o2.getDownloadedPiecesCount());
            }
        });
        for (Piece piece : allPieces) {
            if (piece.isValid()) continue;
            List<SharingPeer> selectedPeers = this.selectGoodPeers(piece, this.peersPerPiece, sorted);
            selectedPieces.put(piece, selectedPeers);
        }
        return new RequestsCollectionImpl(selectedPieces);
    }

    private List<SharingPeer> selectGoodPeers(Piece piece, int count, List<SharingPeer> sortedPeers) {
        ArrayList<SharingPeer> notSelected = new ArrayList<SharingPeer>(sortedPeers);
        Iterator iterator = notSelected.iterator();
        while (iterator.hasNext()) {
            SharingPeer peer = (SharingPeer)iterator.next();
            boolean peerHasCurrentPiece = peer.getAvailablePieces().get(piece.getIndex());
            boolean alreadyRequested = peer.getRequestedPieces().contains(piece);
            if (peerHasCurrentPiece && !alreadyRequested) continue;
            iterator.remove();
        }
        if (notSelected.size() <= count) {
            return notSelected;
        }
        ArrayList<SharingPeer> selected = new ArrayList<SharingPeer>();
        for (int i = 0; i < count; ++i) {
            SharingPeer sharingPeer = this.selectPeer(notSelected);
            if (sharingPeer == null) continue;
            notSelected.remove(sharingPeer);
            selected.add(sharingPeer);
        }
        return selected;
    }

    private SharingPeer selectPeer(List<SharingPeer> notSelected) {
        for (SharingPeer sharingPeer : notSelected) {
            if (!(RANDOM.nextDouble() < 0.8)) continue;
            return sharingPeer;
        }
        return notSelected.get(RANDOM.nextInt(notSelected.size()));
    }
}

