/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common;

import com.turn.ttorrent.common.Optional;
import com.turn.ttorrent.common.TorrentFile;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentUtils;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TorrentMetadataImpl
implements TorrentMetadata {
    private final byte[] myInfoHash;
    @Nullable
    private final List<List<String>> myAnnounceList;
    private final String myMainAnnounce;
    private final long myCreationDate;
    private final String myComment;
    private final String myCreatedBy;
    private final String myName;
    private final List<TorrentFile> myFiles;
    private final int myPieceCount;
    private final int myPieceLength;
    private final byte[] myPiecesHashes;
    private final String myHexString;

    TorrentMetadataImpl(byte[] infoHash, @Nullable List<List<String>> announceList, String mainAnnounce, long creationDate, String comment, String createdBy, String name, List<TorrentFile> files, int pieceCount, int pieceLength, byte[] piecesHashes) {
        this.myInfoHash = infoHash;
        this.myAnnounceList = announceList;
        this.myMainAnnounce = mainAnnounce;
        this.myCreationDate = creationDate;
        this.myComment = comment;
        this.myCreatedBy = createdBy;
        this.myName = name;
        this.myFiles = files;
        this.myPieceCount = pieceCount;
        this.myPieceLength = pieceLength;
        this.myPiecesHashes = piecesHashes;
        this.myHexString = TorrentUtils.byteArrayToHexString(this.myInfoHash);
    }

    @Override
    public String getDirectoryName() {
        return this.myName;
    }

    @Override
    public List<TorrentFile> getFiles() {
        return this.myFiles;
    }

    @Override
    @Nullable
    public List<List<String>> getAnnounceList() {
        return this.myAnnounceList;
    }

    @Override
    @Nullable
    public String getAnnounce() {
        return this.myMainAnnounce;
    }

    @Override
    public Optional<Long> getCreationDate() {
        return Optional.of(this.myCreationDate == -1L ? null : Long.valueOf(this.myCreationDate));
    }

    @Override
    public Optional<String> getComment() {
        return Optional.of(this.myComment);
    }

    @Override
    public Optional<String> getCreatedBy() {
        return Optional.of(this.myCreatedBy);
    }

    @Override
    public int getPieceLength() {
        return this.myPieceLength;
    }

    @Override
    public byte[] getPiecesHashes() {
        return this.myPiecesHashes;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public int getPiecesCount() {
        return this.myPieceCount;
    }

    @Override
    public byte[] getInfoHash() {
        return this.myInfoHash;
    }

    @Override
    public String getHexInfoHash() {
        return this.myHexString;
    }
}

