/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol.http;

import com.turn.ttorrent.Constants;
import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.BEncoder;
import com.turn.ttorrent.bcodec.InvalidBEncodingException;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.TorrentUtils;
import com.turn.ttorrent.common.protocol.AnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.http.HTTPTrackerMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class HTTPAnnounceRequestMessage
extends HTTPTrackerMessage
implements AnnounceRequestMessage {
    private final byte[] infoHash;
    private final Peer peer;
    private final long uploaded;
    private final long downloaded;
    private final long left;
    private final boolean compact;
    private final boolean noPeerId;
    private final AnnounceRequestMessage.RequestEvent event;
    private final int numWant;

    private HTTPAnnounceRequestMessage(ByteBuffer data, byte[] infoHash, Peer peer, long uploaded, long downloaded, long left, boolean compact, boolean noPeerId, AnnounceRequestMessage.RequestEvent event, int numWant) {
        super(TrackerMessage.Type.ANNOUNCE_REQUEST, data);
        this.infoHash = infoHash;
        this.peer = peer;
        this.downloaded = downloaded;
        this.uploaded = uploaded;
        this.left = left;
        this.compact = compact;
        this.noPeerId = noPeerId;
        this.event = event;
        this.numWant = numWant;
    }

    @Override
    public byte[] getInfoHash() {
        return this.infoHash;
    }

    @Override
    public String getHexInfoHash() {
        return TorrentUtils.byteArrayToHexString(this.infoHash);
    }

    @Override
    public byte[] getPeerId() {
        return this.peer.getPeerIdArray();
    }

    @Override
    public String getHexPeerId() {
        return this.peer.getHexPeerId();
    }

    @Override
    public int getPort() {
        return this.peer.getPort();
    }

    @Override
    public long getUploaded() {
        return this.uploaded;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public long getLeft() {
        return this.left;
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    @Override
    public boolean canOmitPeerId() {
        return this.noPeerId;
    }

    @Override
    public AnnounceRequestMessage.RequestEvent getEvent() {
        return this.event;
    }

    @Override
    public String getIp() {
        return this.peer.getIp();
    }

    @Override
    public int getNumWant() {
        return this.numWant;
    }

    @Override
    public String getKey() {
        return "";
    }

    @Override
    public String getTrackerId() {
        return "";
    }

    public URL buildAnnounceURL(URL trackerAnnounceURL) throws UnsupportedEncodingException, MalformedURLException {
        String base = trackerAnnounceURL.toString();
        StringBuilder url = new StringBuilder(base);
        url.append(base.contains("?") ? "&" : "?").append("info_hash=").append(URLEncoder.encode(new String(this.getInfoHash(), "ISO-8859-1"), "ISO-8859-1")).append("&peer_id=").append(URLEncoder.encode(new String(this.getPeerId(), "ISO-8859-1"), "ISO-8859-1")).append("&port=").append(this.getPort()).append("&uploaded=").append(this.getUploaded()).append("&downloaded=").append(this.getDownloaded()).append("&left=").append(this.getLeft()).append("&compact=").append(this.isCompact() ? 1 : 0).append("&no_peer_id=").append(this.canOmitPeerId() ? 1 : 0);
        if (this.getEvent() != null && !AnnounceRequestMessage.RequestEvent.NONE.equals((Object)this.getEvent())) {
            url.append("&event=").append(this.getEvent().getEventName());
        }
        if (this.getIp() != null) {
            url.append("&ip=").append(this.getIp());
        }
        return new URL(url.toString());
    }

    public static HTTPAnnounceRequestMessage parse(BEValue decoded) throws IOException, TrackerMessage.MessageValidationException {
        if (decoded == null) {
            throw new TrackerMessage.MessageValidationException("Could not decode tracker message (not B-encoded?)!");
        }
        Map<String, BEValue> params = decoded.getMap();
        if (!params.containsKey("info_hash")) {
            throw new TrackerMessage.MessageValidationException(TrackerMessage.ErrorMessage.FailureReason.MISSING_HASH.getMessage());
        }
        if (!params.containsKey("peer_id")) {
            throw new TrackerMessage.MessageValidationException(TrackerMessage.ErrorMessage.FailureReason.MISSING_PEER_ID.getMessage());
        }
        if (!params.containsKey("port")) {
            throw new TrackerMessage.MessageValidationException(TrackerMessage.ErrorMessage.FailureReason.MISSING_PORT.getMessage());
        }
        try {
            byte[] infoHash = params.get("info_hash").getBytes();
            byte[] peerId = params.get("peer_id").getBytes();
            int port = params.get("port").getInt();
            long uploaded = 0L;
            if (params.containsKey("uploaded")) {
                uploaded = params.get("uploaded").getLong();
            }
            long downloaded = 0L;
            if (params.containsKey("downloaded")) {
                downloaded = params.get("downloaded").getLong();
            }
            long left = -1L;
            if (params.containsKey("left")) {
                left = params.get("left").getLong();
            }
            boolean compact = false;
            if (params.containsKey("compact")) {
                compact = params.get("compact").getInt() == 1;
            }
            boolean noPeerId = false;
            if (params.containsKey("no_peer_id")) {
                noPeerId = params.get("no_peer_id").getInt() == 1;
            }
            int numWant = 50;
            if (params.containsKey("numwant")) {
                numWant = params.get("numwant").getInt();
            }
            String ip = null;
            if (params.containsKey("ip")) {
                ip = params.get("ip").getString("ISO-8859-1");
            }
            AnnounceRequestMessage.RequestEvent event = AnnounceRequestMessage.RequestEvent.NONE;
            if (params.containsKey("event")) {
                event = AnnounceRequestMessage.RequestEvent.getByName(params.get("event").getString("ISO-8859-1"));
            }
            return new HTTPAnnounceRequestMessage(Constants.EMPTY_BUFFER, infoHash, new Peer(ip, port, ByteBuffer.wrap(peerId)), uploaded, downloaded, left, compact, noPeerId, event, numWant);
        }
        catch (InvalidBEncodingException ibee) {
            throw new TrackerMessage.MessageValidationException("Invalid HTTP tracker request!", ibee);
        }
    }

    public static HTTPAnnounceRequestMessage craft(byte[] infoHash, byte[] peerId, int port, long uploaded, long downloaded, long left, boolean compact, boolean noPeerId, AnnounceRequestMessage.RequestEvent event, String ip, int numWant) throws IOException {
        HashMap<String, BEValue> params = new HashMap<String, BEValue>();
        params.put("info_hash", new BEValue(infoHash));
        params.put("peer_id", new BEValue(peerId));
        params.put("port", new BEValue(port));
        params.put("uploaded", new BEValue(uploaded));
        params.put("downloaded", new BEValue(downloaded));
        params.put("left", new BEValue(left));
        params.put("compact", new BEValue(compact ? 1 : 0));
        params.put("no_peer_id", new BEValue(noPeerId ? 1 : 0));
        if (event != null) {
            params.put("event", new BEValue(event.getEventName(), "ISO-8859-1"));
        }
        if (ip != null) {
            params.put("ip", new BEValue(ip, "ISO-8859-1"));
        }
        if (numWant != 50) {
            params.put("numwant", new BEValue(numWant));
        }
        return new HTTPAnnounceRequestMessage(BEncoder.bencode(params), infoHash, new Peer(ip, port, ByteBuffer.wrap(peerId)), uploaded, downloaded, left, compact, noPeerId, event, numWant);
    }
}

