/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.network;

import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.TimeService;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.network.ConnectTask;
import com.turn.ttorrent.network.ConnectionClosedException;
import com.turn.ttorrent.network.NewConnectionAllower;
import com.turn.ttorrent.network.WriteAttachment;
import com.turn.ttorrent.network.WriteTask;
import com.turn.ttorrent.network.keyProcessors.CleanupProcessor;
import com.turn.ttorrent.network.keyProcessors.KeyProcessor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ConnectionWorker
implements Runnable {
    private static final Logger logger = TorrentLoggerFactory.getLogger(ConnectionWorker.class);
    private static final String SELECTOR_THREAD_NAME = "Torrent channels manager thread";
    private volatile boolean stop = false;
    private final Selector selector;
    private final BlockingQueue<ConnectTask> myConnectQueue;
    private final BlockingQueue<WriteTask> myWriteQueue;
    private final Semaphore mySemaphore;
    private final List<KeyProcessor> myKeyProcessors;
    private final TimeService myTimeService;
    private long lastCleanupTime;
    private volatile int mySelectorTimeoutMillis;
    private volatile long myCleanupTimeoutMillis;
    private final CleanupProcessor myCleanupProcessor;
    private final NewConnectionAllower myNewConnectionAllower;

    ConnectionWorker(Selector selector, List<KeyProcessor> keyProcessors, int selectorTimeoutMillis, int cleanupTimeoutMillis, TimeService timeService, CleanupProcessor cleanupProcessor, NewConnectionAllower myNewConnectionAllower) {
        this.selector = selector;
        this.myTimeService = timeService;
        this.lastCleanupTime = timeService.now();
        this.mySelectorTimeoutMillis = selectorTimeoutMillis;
        this.myCleanupTimeoutMillis = cleanupTimeoutMillis;
        this.myCleanupProcessor = cleanupProcessor;
        this.myNewConnectionAllower = myNewConnectionAllower;
        this.mySemaphore = new Semaphore(1);
        this.myConnectQueue = new LinkedBlockingQueue<ConnectTask>(100);
        this.myKeyProcessors = keyProcessors;
        this.myWriteQueue = new LinkedBlockingQueue<WriteTask>(5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mySemaphore.acquire();
        }
        catch (InterruptedException e) {
            return;
        }
        String oldName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(SELECTOR_THREAD_NAME);
            while (!this.stop && !Thread.currentThread().isInterrupted()) {
                try {
                    int selected;
                    logger.trace("try select keys from selector");
                    try {
                        selected = this.selector.select(this.mySelectorTimeoutMillis);
                    }
                    catch (ClosedSelectorException e) {
                        break;
                    }
                    this.connectToPeersFromQueue();
                    this.processWriteTasks();
                    logger.trace("select keys from selector. Keys count is " + selected);
                    if (selected != 0) {
                        this.processSelectedKeys();
                    }
                    if (!this.needRunCleanup()) continue;
                    this.cleanup();
                }
                catch (Throwable e) {
                    LoggerUtils.warnAndDebugDetails(logger, "unable to select channel keys. Error message {}", e.getMessage(), e);
                }
            }
        }
        catch (Throwable e) {
            LoggerUtils.errorAndDebugDetails(logger, "exception on cycle iteration", e);
        }
        finally {
            Thread.currentThread().setName(oldName);
            this.mySemaphore.release();
        }
    }

    private void cleanup() {
        this.lastCleanupTime = this.myTimeService.now();
        for (SelectionKey key : this.selector.keys()) {
            if (!key.isValid()) continue;
            this.myCleanupProcessor.processCleanup(key);
        }
    }

    private boolean needRunCleanup() {
        return this.myTimeService.now() - this.lastCleanupTime > this.myCleanupTimeoutMillis;
    }

    private void processWriteTasks() {
        Iterator iterator = this.myWriteQueue.iterator();
        while (iterator.hasNext()) {
            WriteTask writeTask = (WriteTask)iterator.next();
            if (this.stop || Thread.currentThread().isInterrupted()) {
                return;
            }
            logger.trace("try register channel for write. Write task is {}", writeTask);
            SocketChannel socketChannel = (SocketChannel)writeTask.getSocketChannel();
            if (!socketChannel.isOpen()) {
                iterator.remove();
                writeTask.getListener().onWriteFailed(this.getDefaultWriteErrorMessageWithSuffix(socketChannel, "Channel is not open"), new ConnectionClosedException());
                continue;
            }
            SelectionKey key = socketChannel.keyFor(this.selector);
            if (key == null) {
                logger.warn("unable to find key for channel {}", socketChannel);
                iterator.remove();
                writeTask.getListener().onWriteFailed(this.getDefaultWriteErrorMessageWithSuffix(socketChannel, "Can not find key for the channel"), new ConnectionClosedException());
                continue;
            }
            Object attachment = key.attachment();
            if (!(attachment instanceof WriteAttachment)) {
                logger.error("incorrect attachment {} for channel {}", attachment, (Object)socketChannel);
                iterator.remove();
                writeTask.getListener().onWriteFailed(this.getDefaultWriteErrorMessageWithSuffix(socketChannel, "Incorrect attachment instance for the key"), new ConnectionClosedException());
                continue;
            }
            WriteAttachment keyAttachment = (WriteAttachment)attachment;
            if (!keyAttachment.getWriteTasks().offer(writeTask)) continue;
            iterator.remove();
            try {
                key.interestOps(key.interestOps() | 4);
            }
            catch (CancelledKeyException e) {
                writeTask.getListener().onWriteFailed(this.getDefaultWriteErrorMessageWithSuffix(socketChannel, "Key is cancelled"), new ConnectionClosedException(e));
            }
        }
    }

    private String getDefaultWriteErrorMessageWithSuffix(SocketChannel socketChannel, String suffix) {
        return "unable write data to channel " + socketChannel + ". " + suffix;
    }

    private void connectToPeersFromQueue() {
        ConnectTask connectTask;
        while ((connectTask = (ConnectTask)this.myConnectQueue.poll()) != null) {
            if (this.stop || Thread.currentThread().isInterrupted()) {
                return;
            }
            logger.debug("try connect to peer. Connect task is {}", connectTask);
            try {
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(false);
                socketChannel.register(this.selector, 8, connectTask);
                socketChannel.connect(new InetSocketAddress(connectTask.getHost(), connectTask.getPort()));
            }
            catch (IOException e) {
                LoggerUtils.warnAndDebugDetails(logger, "unable connect. Connect task is {}", connectTask, e);
            }
        }
    }

    public boolean stop(int timeout, TimeUnit timeUnit) throws InterruptedException {
        this.stop = true;
        if (timeout <= 0) {
            return true;
        }
        return this.mySemaphore.tryAcquire(timeout, timeUnit);
    }

    private void processSelectedKeys() {
        Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
        for (SelectionKey key : selectionKeys) {
            if (this.stop || Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                this.processSelectedKey(key);
            }
            catch (Exception e) {
                logger.warn("error {} in processing key. Close channel {}", (Object)e.getMessage(), (Object)key.channel());
                logger.debug("", e);
                try {
                    key.channel().close();
                }
                catch (IOException ioe) {
                    LoggerUtils.errorAndDebugDetails(logger, "unable close bad channel", ioe);
                }
            }
        }
        selectionKeys.clear();
    }

    private void processSelectedKey(SelectionKey key) throws IOException {
        logger.trace("try process key for channel {}", key.channel());
        this.myCleanupProcessor.processSelected(key);
        if (!key.channel().isOpen()) {
            key.cancel();
            return;
        }
        for (KeyProcessor keyProcessor : this.myKeyProcessors) {
            if (!keyProcessor.accept(key)) continue;
            keyProcessor.process(key);
        }
    }

    public boolean offerConnect(ConnectTask connectTask, int timeout, TimeUnit timeUnit) {
        if (!this.myNewConnectionAllower.isNewConnectionAllowed()) {
            logger.info("can not add connect task {} to queue. New connection is not allowed", connectTask);
            return false;
        }
        return this.addTaskToQueue(connectTask, timeout, timeUnit, this.myConnectQueue);
    }

    public boolean offerWrite(WriteTask writeTask, int timeout, TimeUnit timeUnit) {
        boolean done = this.addTaskToQueue(writeTask, timeout, timeUnit, this.myWriteQueue);
        if (!done) {
            writeTask.getListener().onWriteFailed("unable add task " + writeTask + " to the queue. Maybe queue is overload", null);
        }
        return done;
    }

    private <T> boolean addTaskToQueue(T task, int timeout, TimeUnit timeUnit, BlockingQueue<T> queue) {
        try {
            if (queue.offer(task, timeout, timeUnit)) {
                logger.trace("added task {}. Wake up selector", task);
                this.selector.wakeup();
                return true;
            }
        }
        catch (InterruptedException e) {
            logger.debug("Task {} interrupted before was added to queue", task);
        }
        logger.debug("Task {} was not added", task);
        return false;
    }

    void setCleanupTimeout(long timeoutMillis) {
        this.myCleanupTimeoutMillis = timeoutMillis;
    }

    void setSelectorSelectTimeout(int timeout) {
        this.mySelectorTimeoutMillis = timeout;
    }
}

