/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.common.TorrentHash;
import com.turn.ttorrent.common.TorrentUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.ParseException;

public class Handshake
implements TorrentHash {
    public static final String BITTORRENT_PROTOCOL_IDENTIFIER = "BitTorrent protocol";
    public static final int BASE_HANDSHAKE_LENGTH = 49;
    private ByteBuffer data;
    private ByteBuffer infoHash;
    private ByteBuffer peerId;
    private String torrentIdentifier;
    private int myPstrlen;

    private Handshake(ByteBuffer data, ByteBuffer infoHash, ByteBuffer peerId) {
        this.data = data;
        this.data.rewind();
        this.infoHash = infoHash;
        this.peerId = peerId;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public byte[] getInfoHash() {
        return this.infoHash.array();
    }

    public String getHexInfoHash() {
        return TorrentUtils.byteArrayToHexString((byte[])this.getInfoHash());
    }

    public byte[] getPeerId() {
        return this.peerId.array();
    }

    public static Handshake parse(ByteBuffer buffer) throws ParseException, UnsupportedEncodingException {
        int pstrlen = Byte.valueOf(buffer.get()).intValue();
        if (pstrlen < 0 || buffer.remaining() != 49 + pstrlen - 1) {
            throw new ParseException("Incorrect handshake message length (pstrlen=" + pstrlen + ") !", 0);
        }
        byte[] pstr = new byte[pstrlen];
        buffer.get(pstr);
        if (!BITTORRENT_PROTOCOL_IDENTIFIER.equals(new String(pstr, "ISO-8859-1"))) {
            throw new ParseException("Invalid protocol identifier!", 1);
        }
        byte[] reserved = new byte[8];
        buffer.get(reserved);
        byte[] infoHash = new byte[20];
        buffer.get(infoHash);
        byte[] peerId = new byte[20];
        buffer.get(peerId);
        return new Handshake(buffer, ByteBuffer.wrap(infoHash), ByteBuffer.wrap(peerId));
    }

    public static Handshake parse(ByteBuffer buffer, String torrentIdentifier) throws UnsupportedEncodingException, ParseException {
        Handshake hs = Handshake.parse(buffer);
        hs.setTorrentIdentifier(torrentIdentifier);
        return hs;
    }

    public static Handshake parse(ByteBuffer buffer, int pstrlen) throws UnsupportedEncodingException, ParseException {
        Handshake hs = Handshake.parse(buffer);
        hs.myPstrlen = pstrlen;
        return hs;
    }

    public static Handshake craft(byte[] torrentInfoHash, byte[] clientPeerId) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(49 + BITTORRENT_PROTOCOL_IDENTIFIER.length());
            byte[] reserved = new byte[8];
            ByteBuffer infoHash = ByteBuffer.wrap(torrentInfoHash);
            ByteBuffer peerId = ByteBuffer.wrap(clientPeerId);
            buffer.put((byte)BITTORRENT_PROTOCOL_IDENTIFIER.length());
            buffer.put(BITTORRENT_PROTOCOL_IDENTIFIER.getBytes("ISO-8859-1"));
            buffer.put(reserved);
            buffer.put(infoHash);
            buffer.put(peerId);
            return new Handshake(buffer, infoHash, peerId);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public static Handshake parse(byte[] torrentInfoHash, byte[] clientPeerId, String torrentIdentifier) throws UnsupportedEncodingException, ParseException {
        Handshake hs = Handshake.craft(torrentInfoHash, clientPeerId);
        hs.setTorrentIdentifier(torrentIdentifier);
        return hs;
    }

    public void setTorrentIdentifier(String torrentIdentifier) {
        this.torrentIdentifier = torrentIdentifier;
    }

    public int getPstrlen() {
        return this.myPstrlen;
    }

    public String getTorrentIdentifier() {
        return this.torrentIdentifier;
    }
}

