/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.EventDispatcher;
import com.turn.ttorrent.client.TorrentListener;
import com.turn.ttorrent.client.TorrentListenerWrapper;
import com.turn.ttorrent.client.TorrentManager;
import com.turn.ttorrent.common.TorrentHash;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class TorrentManagerImpl
implements TorrentManager {
    private final EventDispatcher eventDispatcher;
    private final TorrentHash hash;

    TorrentManagerImpl(EventDispatcher eventDispatcher, TorrentHash hash) {
        this.eventDispatcher = eventDispatcher;
        this.hash = hash;
    }

    @Override
    public void addListener(TorrentListener listener) {
        this.eventDispatcher.addListener(listener);
    }

    @Override
    public boolean removeListener(TorrentListener listener) {
        return this.eventDispatcher.removeListener(listener);
    }

    public byte[] getInfoHash() {
        return this.hash.getInfoHash();
    }

    public String getHexInfoHash() {
        return this.hash.getHexInfoHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitDownloadComplete(int timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        final Semaphore semaphore = new Semaphore(0);
        TorrentListenerWrapper listener = new TorrentListenerWrapper(){

            @Override
            public void downloadComplete() {
                semaphore.release();
            }
        };
        try {
            this.addListener(listener);
            if (!semaphore.tryAcquire(timeout, timeUnit)) {
                throw new TimeoutException("Unable to download torrent in specified timeout");
            }
        }
        finally {
            this.removeListener(listener);
        }
    }
}

