/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.storage;

import com.turn.ttorrent.client.storage.PieceStorage;
import com.turn.ttorrent.client.storage.TorrentByteStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.Nullable;

public class PieceStorageImpl
implements PieceStorage {
    private final TorrentByteStorage fileCollectionStorage;
    private final ReadWriteLock readWriteLock;
    private final Object openStorageLock = new Object();
    @Nullable
    private volatile BitSet availablePieces;
    private final int piecesCount;
    private final int pieceSize;
    private volatile boolean isOpen;
    private volatile boolean closedFully = false;

    public PieceStorageImpl(TorrentByteStorage fileCollectionStorage, BitSet availablePieces, int piecesCount, int pieceSize) {
        this.fileCollectionStorage = fileCollectionStorage;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.piecesCount = piecesCount;
        this.pieceSize = pieceSize;
        BitSet bitSet = new BitSet(piecesCount);
        bitSet.or(availablePieces);
        if (bitSet.cardinality() != piecesCount) {
            this.availablePieces = bitSet;
        }
        this.isOpen = false;
    }

    private void checkPieceIndex(int pieceIndex) {
        if (pieceIndex < 0 || pieceIndex >= this.piecesCount) {
            throw new IllegalArgumentException("Incorrect piece index " + pieceIndex + ". Piece index must be positive less than" + this.piecesCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePiece(int pieceIndex, byte[] pieceData) throws IOException {
        this.checkPieceIndex(pieceIndex);
        try {
            boolean isFullyNow;
            boolean isFullyDownloaded;
            this.readWriteLock.writeLock().lock();
            if (this.closedFully) {
                throw new IOException("Storage is closed");
            }
            BitSet availablePieces = this.availablePieces;
            boolean bl = isFullyDownloaded = availablePieces == null;
            if (isFullyDownloaded) {
                return;
            }
            if (availablePieces.get(pieceIndex)) {
                return;
            }
            this.openStorageIsNecessary(false);
            long pos = pieceIndex;
            ByteBuffer buffer = ByteBuffer.wrap(pieceData);
            this.fileCollectionStorage.write(buffer, pos *= (long)this.pieceSize);
            availablePieces.set(pieceIndex);
            boolean bl2 = isFullyNow = availablePieces.cardinality() == this.piecesCount;
            if (isFullyNow) {
                this.availablePieces = null;
                this.fileCollectionStorage.finish();
                this.fileCollectionStorage.close();
                this.fileCollectionStorage.open(true);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void openStorageIsNecessary(boolean onlyRead) throws IOException {
        if (!this.isOpen) {
            this.fileCollectionStorage.open(onlyRead);
            this.isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readPiecePart(int pieceIndex, int offset, int length) throws IOException {
        this.checkPieceIndex(pieceIndex);
        try {
            this.readWriteLock.readLock().lock();
            if (this.closedFully) {
                throw new IOException("Storage is closed");
            }
            BitSet availablePieces = this.availablePieces;
            if (availablePieces != null && !availablePieces.get(pieceIndex)) {
                throw new IllegalArgumentException("trying reading part of not available piece");
            }
            Object object = this.openStorageLock;
            synchronized (object) {
                this.openStorageIsNecessary(availablePieces == null);
            }
            ByteBuffer buffer = ByteBuffer.allocate(length);
            long pos = pieceIndex;
            pos = pos * (long)this.pieceSize + (long)offset;
            this.fileCollectionStorage.read(buffer, pos);
            byte[] byArray = buffer.array();
            return byArray;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public boolean isFinished() {
        try {
            this.readWriteLock.readLock().lock();
            boolean bl = this.availablePieces == null;
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void closeFully() throws IOException {
        try {
            this.readWriteLock.writeLock().lock();
            this.close0();
            this.closedFully = true;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BitSet getAvailablePieces() {
        try {
            boolean isFullyDownloaded;
            this.readWriteLock.readLock().lock();
            BitSet result = new BitSet(this.piecesCount);
            BitSet availablePieces = this.availablePieces;
            boolean bl = isFullyDownloaded = availablePieces == null;
            if (isFullyDownloaded) {
                result.set(0, this.piecesCount);
                BitSet bitSet = result;
                return bitSet;
            }
            result.or(availablePieces);
            BitSet bitSet = result;
            return bitSet;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.readWriteLock.writeLock().lock();
            this.close0();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void close0() throws IOException {
        if (!this.isOpen) {
            return;
        }
        this.fileCollectionStorage.close();
        this.isOpen = false;
    }
}

