package com.ruoyi.web.Server.validator;

import com.ruoyi.web.Server.BT.TorrentService;
import com.ruoyi.web.controller.common.exception.TrackerException;
import com.ruoyi.web.domain.BT.TorrentEntity;
import com.ruoyi.web.dao.BT.AnnounceRequest;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;


@RequiredArgsConstructor
@Component
public class TorrentValidator implements TrackerValidator {


    final TorrentService torrentService;

    @Override
    public void validate(AnnounceRequest request) {
        TorrentEntity torrentEntity = torrentService.getByInfoHash(request.getInfoHash());

        if (torrentEntity == null) {
            throw new TrackerException("Torrent is not authorized for use on this tracker");
        }


        if (!torrentEntity.isStatusOK()) {
            throw new TrackerException("Torrent status not ok, please keep seeding.");
        }


        request.setTorrent(torrentEntity);

    }

    @Override
    public int getOrder() {
        return 101;
    }


}
