package com.ruoyi.web.controller.common.exception;

import com.ruoyi.web.Tool.BT.BencodeUtil;
import com.ruoyi.web.controller.BT.TrackerController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author plexpt
 */
@Slf4j
@RestControllerAdvice(assignableTypes = TrackerController.class)
public class ExceptionControllerAdviceTracker {


    @ExceptionHandler(TrackerException.class)
    public String invalidLengthExceptionHandler(TrackerException exception) {

        return BencodeUtil.error(exception.getMessage());
    }

    @ExceptionHandler(Exception.class)
    public String e(Exception exception) {
        return BencodeUtil.error(exception.getMessage());
    }


}

