package com.ruoyi.web.controller.post.mapper;

import java.util.List;

import com.ruoyi.web.controller.post.domain.Post;
import org.apache.ibatis.annotations.Param;

/**
 * 帖子内容Mapper接口
 * 
 * @author thunderhub
 */
public interface PostContentMapper 
{
    /**
     * 查询帖子信息
     * 
     * @param postId 帖子ID
     * @return 帖子信息
     */
    public Post selectPostById(Long postId);

    /**
     * 查询帖子列表
     * 
     * @param post 帖子信息
     * @return 帖子集合
     */
    public List<Post> selectPostList(Post post);

    /**
     * 查询作者的其他帖子
     * 
     * @param authorId 作者ID
     * @param postId 当前帖子ID（排除）
     * @param limit 查询数量
     * @return 帖子集合
     */
    public List<Post> selectAuthorOtherPosts(@Param("authorId") Long authorId, @Param("postId") Long postId, @Param("limit") int limit);

    /**
     * 查询相似标签的帖子
     * 
     * @param tags 标签字符串
     * @param postId 当前帖子ID（排除）
     * @param limit 查询数量
     * @return 帖子集合
     */
    public List<Post> selectSimilarTagsPosts(@Param("tags") String tags, @Param("postId") Long postId, @Param("limit") int limit);

    /**
     * 新增帖子
     * 
     * @param post 帖子信息
     * @return 结果
     */
    public int insertPost(Post post);

    /**
     * 修改帖子
     * 
     * @param post 帖子信息
     * @return 结果
     */
    public int updatePost(Post post);

    /**
     * 删除帖子
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int deletePostById(Long postId);

    /**
     * 批量删除帖子
     * 
     * @param postIds 需要删除的帖子ID
     * @return 结果
     */
    public int deletePostByIds(Long[] postIds);

    /**
     * 更新帖子浏览量
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int updatePostViews(Long postId);

    /**
     * 更新帖子评论数
     * 
     * @param post 帖子信息
     * @return 结果
     */
    public int updatePostComments(Post post);

    /**
     * 更新帖子收藏数
     * 
     * @param post 帖子信息
     * @return 结果
     */
    public int updatePostFavorites(Post post);

    /**
     * 更新帖子点赞数
     * 
     * @param post 帖子信息
     * @return 结果
     */
    public int updatePostLikes(Post post);
} 