package com.ruoyi.web.controller.post.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ruoyi.web.controller.post.domain.PostTag;
import com.ruoyi.web.controller.post.domain.PostTagRelation;
import com.ruoyi.web.controller.post.mapper.PostContentTagMapper;
import com.ruoyi.web.controller.post.service.IPostTagService;

/**
 * 帖子标签 服务层实现
 * 
 * @author thunderhub
 */
@Service
public class PostTagServiceImpl implements IPostTagService
{
    @Autowired
    private PostContentTagMapper postContentTagMapper;

    /**
     * 查询帖子标签信息
     * 
     * @param tagId 帖子标签ID
     * @return 帖子标签信息
     */
    @Override
    public PostTag selectPostTagById(Long tagId)
    {
        return postContentTagMapper.selectPostTagById(tagId);
    }

    /**
     * 查询帖子标签列表
     * 
     * @param postTag 帖子标签信息
     * @return 帖子标签集合
     */
    @Override
    public List<PostTag> selectPostTagList(PostTag postTag)
    {
        return postContentTagMapper.selectPostTagList(postTag);
    }

    /**
     * 根据帖子ID查询标签
     * 
     * @param postId 帖子ID
     * @return 帖子标签集合
     */
    @Override
    public List<PostTag> selectPostTagsByPostId(Long postId)
    {
        return postContentTagMapper.selectPostTagsByPostId(postId);
    }

    /**
     * 新增帖子标签
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    @Override
    public int insertPostTag(PostTag postTag)
    {
        return postContentTagMapper.insertPostTag(postTag);
    }

    /**
     * 修改帖子标签
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    @Override
    public int updatePostTag(PostTag postTag)
    {
        return postContentTagMapper.updatePostTag(postTag);
    }

    /**
     * 删除帖子标签信息
     * 
     * @param tagId 帖子标签ID
     * @return 结果
     */
    @Override
    public int deletePostTagById(Long tagId)
    {
        return postContentTagMapper.deletePostTagById(tagId);
    }

    /**
     * 批量删除帖子标签信息
     * 
     * @param tagIds 需要删除的帖子标签ID
     * @return 结果
     */
    @Override
    public int deletePostTagByIds(Long[] tagIds)
    {
        return postContentTagMapper.deletePostTagByIds(tagIds);
    }

    /**
     * 批量插入帖子标签关联
     * 
     * @param postId 帖子ID
     * @param tagIds 标签ID数组
     * @return 结果
     */
    @Override
    @Transactional
    public int batchInsertPostTagRelation(Long postId, Long[] tagIds)
    {
        List<PostTagRelation> list = new ArrayList<PostTagRelation>();
        for (Long tagId : tagIds)
        {
            PostTagRelation relation = new PostTagRelation();
            relation.setPostId(postId);
            relation.setTagId(tagId);
            list.add(relation);
        }
        return postContentTagMapper.batchInsertPostTagRelation(list);
    }

    /**
     * 删除帖子标签关联
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    @Override
    public int deletePostTagRelation(Long postId)
    {
        return postContentTagMapper.deletePostTagRelation(postId);
    }

    /**
     * 更新标签帖子数量
     * 
     * @param tagId 标签ID
     * @param count 增加/减少的数量
     * @return 结果
     */
    @Override
    public int updatePostTagCount(Long tagId, int count)
    {
        PostTag postTag = new PostTag();
        postTag.setTagId(tagId);
        postTag.setPostCount((long) count);
        return postContentTagMapper.updatePostTagCount(postTag);
    }

    /**
     * 检查标签名称是否唯一
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    @Override
    public boolean checkTagNameUnique(PostTag postTag)
    {
        Long tagId = postTag.getTagId() == null ? -1L : postTag.getTagId();
        PostTag info = postContentTagMapper.checkTagNameUnique(postTag.getTagName());
        if (info != null && info.getTagId().longValue() != tagId.longValue())
        {
            return false;
        }
        return true;
    }
} 