package com.ruoyi.web.domain.BT.dto;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class TorrentSearchRequest {
    // 精准搜索字段
    private String infoHash;      // 种子哈希
    private Integer category;     // 类别
    private Integer status;       // 状态
    private Integer fileStatus;   // 文件状态
    private Integer owner;        // 拥有者
    private Integer type;         // 类型

    // 模糊搜索字段
    private String nameKeyword;   // 名称关键词
    private String titleKeyword;  // 标题关键词
    private String descriptionKeyword; // 描述关键词

    // 范围搜索字段
    private Long minSize;         // 最小文件大小
    private Long maxSize;         // 最大文件大小
    private LocalDateTime createTimeStart; // 创建时间开始
    private LocalDateTime createTimeEnd;   // 创建时间结束

    // 排序字段
    private String sortField = "createTime"; // 排序字段，默认按创建时间
    private String sortDirection = "desc";   // 排序方向，默认降序

    // 分页信息
    private Integer pageNum = 1;    // 当前页码
    private Integer pageSize = 20;  // 每页数量
}
