/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.ClientState;
import com.turn.ttorrent.client.Context;
import com.turn.ttorrent.client.EventDispatcher;
import com.turn.ttorrent.client.FileMetadataProvider;
import com.turn.ttorrent.client.LoadedTorrent;
import com.turn.ttorrent.client.LoadedTorrentImpl;
import com.turn.ttorrent.client.PeersStorage;
import com.turn.ttorrent.client.Piece;
import com.turn.ttorrent.client.SelectorFactoryImpl;
import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.TorrentListener;
import com.turn.ttorrent.client.TorrentLoader;
import com.turn.ttorrent.client.TorrentLoaderImpl;
import com.turn.ttorrent.client.TorrentManager;
import com.turn.ttorrent.client.TorrentManagerImpl;
import com.turn.ttorrent.client.TorrentMetadataProvider;
import com.turn.ttorrent.client.TorrentsStorage;
import com.turn.ttorrent.client.announce.Announce;
import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.client.announce.AnnounceResponseListener;
import com.turn.ttorrent.client.announce.TrackerClientFactory;
import com.turn.ttorrent.client.announce.TrackerClientFactoryImpl;
import com.turn.ttorrent.client.network.CountLimitConnectionAllower;
import com.turn.ttorrent.client.network.OutgoingConnectionListener;
import com.turn.ttorrent.client.network.StateChannelListener;
import com.turn.ttorrent.client.peer.PeerActivityListener;
import com.turn.ttorrent.client.peer.SharingPeer;
import com.turn.ttorrent.client.storage.FairPieceStorageFactory;
import com.turn.ttorrent.client.storage.FileCollectionStorage;
import com.turn.ttorrent.client.storage.PieceStorage;
import com.turn.ttorrent.client.storage.PieceStorageFactory;
import com.turn.ttorrent.common.AnnounceableInformation;
import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.Pair;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.PeerUID;
import com.turn.ttorrent.common.SystemTimeService;
import com.turn.ttorrent.common.TorrentFile;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentStatistic;
import com.turn.ttorrent.common.TorrentUtils;
import com.turn.ttorrent.common.protocol.AnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.PeerMessage;
import com.turn.ttorrent.network.ConnectTask;
import com.turn.ttorrent.network.ConnectionListener;
import com.turn.ttorrent.network.ConnectionManager;
import com.turn.ttorrent.network.ConnectionManagerContext;
import com.turn.ttorrent.network.FirstAvailableChannel;
import com.turn.ttorrent.network.SelectorFactory;
import com.turn.ttorrent.network.ServerChannelRegister;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class CommunicationManager
implements AnnounceResponseListener,
PeerActivityListener,
Context,
ConnectionManagerContext {
    protected static final Logger logger = TorrentLoggerFactory.getLogger(CommunicationManager.class);
    public static final String BITTORRENT_ID_PREFIX = "-TO0042-";
    private AtomicBoolean stop = new AtomicBoolean(false);
    private Announce announce;
    private volatile boolean myStarted = false;
    private final TorrentLoader myTorrentLoader;
    private final TorrentsStorage torrentsStorage;
    private final CountLimitConnectionAllower myInConnectionAllower;
    private final CountLimitConnectionAllower myOutConnectionAllower;
    private final AtomicInteger mySendBufferSize;
    private final AtomicInteger myReceiveBufferSize;
    private final PeersStorage peersStorage;
    private volatile ConnectionManager myConnectionManager;
    private final ExecutorService myExecutorService;
    private final ExecutorService myPieceValidatorExecutor;

    public CommunicationManager(ExecutorService workingExecutor, ExecutorService pieceValidatorExecutor) {
        this(workingExecutor, pieceValidatorExecutor, new TrackerClientFactoryImpl());
    }

    public CommunicationManager(ExecutorService workingExecutor, ExecutorService pieceValidatorExecutor, TrackerClientFactory trackerClientFactory) {
        this.announce = new Announce(this, trackerClientFactory);
        this.torrentsStorage = new TorrentsStorage();
        this.peersStorage = new PeersStorage();
        this.mySendBufferSize = new AtomicInteger();
        this.myTorrentLoader = new TorrentLoaderImpl(this.torrentsStorage);
        this.myReceiveBufferSize = new AtomicInteger();
        this.myInConnectionAllower = new CountLimitConnectionAllower(this.peersStorage);
        this.myOutConnectionAllower = new CountLimitConnectionAllower(this.peersStorage);
        this.myExecutorService = workingExecutor;
        this.myPieceValidatorExecutor = pieceValidatorExecutor;
    }

    public TorrentManager addTorrent(String dotTorrentFilePath, String downloadDirPath) throws IOException {
        return this.addTorrent(dotTorrentFilePath, downloadDirPath, FairPieceStorageFactory.INSTANCE);
    }

    public TorrentManager addTorrent(String dotTorrentFilePath, String downloadDirPath, List<TorrentListener> listeners) throws IOException {
        return this.addTorrent(dotTorrentFilePath, downloadDirPath, FairPieceStorageFactory.INSTANCE, listeners);
    }

    public TorrentManager addTorrent(String dotTorrentFilePath, String downloadDirPath, PieceStorageFactory pieceStorageFactory) throws IOException {
        return this.addTorrent(dotTorrentFilePath, downloadDirPath, pieceStorageFactory, Collections.<TorrentListener>emptyList());
    }

    public TorrentManager addTorrent(String dotTorrentFilePath, String downloadDirPath, PieceStorageFactory pieceStorageFactory, List<TorrentListener> listeners) throws IOException {
        FileMetadataProvider metadataProvider = new FileMetadataProvider(dotTorrentFilePath);
        TorrentMetadata metadata = metadataProvider.getTorrentMetadata();
        FileCollectionStorage fileCollectionStorage = FileCollectionStorage.create(metadata, new File(downloadDirPath));
        PieceStorage pieceStorage = pieceStorageFactory.createStorage(metadata, fileCollectionStorage);
        return this.addTorrent(metadataProvider, pieceStorage, listeners);
    }

    public TorrentManager addTorrent(TorrentMetadataProvider metadataProvider, PieceStorage pieceStorage) throws IOException {
        return this.addTorrent(metadataProvider, pieceStorage, Collections.<TorrentListener>emptyList());
    }

    public TorrentManager addTorrent(TorrentMetadataProvider metadataProvider, PieceStorage pieceStorage, List<TorrentListener> listeners) throws IOException {
        TorrentMetadata torrentMetadata = metadataProvider.getTorrentMetadata();
        EventDispatcher eventDispatcher = new EventDispatcher();
        for (TorrentListener listener : listeners) {
            eventDispatcher.addListener(listener);
        }
        LoadedTorrentImpl loadedTorrent = new LoadedTorrentImpl(new TorrentStatistic(), metadataProvider, torrentMetadata, pieceStorage, eventDispatcher);
        if (pieceStorage.isFinished()) {
            loadedTorrent.getTorrentStatistic().setLeft(0L);
        } else {
            long left = this.calculateLeft(pieceStorage, torrentMetadata);
            loadedTorrent.getTorrentStatistic().setLeft(left);
        }
        eventDispatcher.multicaster().validationComplete(pieceStorage.getAvailablePieces().cardinality(), torrentMetadata.getPiecesCount());
        this.torrentsStorage.addTorrent(loadedTorrent.getTorrentHash().getHexInfoHash(), loadedTorrent);
        this.forceAnnounceAndLogError(loadedTorrent, pieceStorage.isFinished() ? AnnounceRequestMessage.RequestEvent.COMPLETED : AnnounceRequestMessage.RequestEvent.STARTED);
        logger.debug(String.format("Added torrent %s (%s)", loadedTorrent, loadedTorrent.getTorrentHash().getHexInfoHash()));
        return new TorrentManagerImpl(eventDispatcher, loadedTorrent.getTorrentHash());
    }

    private long calculateLeft(PieceStorage pieceStorage, TorrentMetadata torrentMetadata) {
        long size = 0L;
        for (TorrentFile torrentFile : torrentMetadata.getFiles()) {
            size += torrentFile.size;
        }
        int pieceLength = torrentMetadata.getPieceLength();
        long result = 0L;
        BitSet availablePieces = pieceStorage.getAvailablePieces();
        for (int i = 0; i < torrentMetadata.getPiecesCount(); ++i) {
            if (availablePieces.get(i)) continue;
            result += Math.min((long)pieceLength, size - (long)(i * pieceLength));
        }
        return result;
    }

    private void forceAnnounceAndLogError(LoadedTorrent torrent, AnnounceRequestMessage.RequestEvent event) {
        try {
            this.announce.forceAnnounce(torrent.createAnnounceableInformation(), this, event);
        }
        catch (IOException e) {
            logger.warn("unable to force announce torrent {}", torrent);
            logger.debug("", e);
        }
    }

    public void removeTorrent(String torrentHash) {
        logger.debug("Stopping seeding " + torrentHash);
        Pair<SharedTorrent, LoadedTorrent> torrents = this.torrentsStorage.remove(torrentHash);
        SharedTorrent torrent = torrents.first();
        if (torrent != null) {
            torrent.setClientState(ClientState.DONE);
            torrent.closeFully();
        }
        List<SharingPeer> peers = this.getPeersForTorrent(torrentHash);
        for (SharingPeer peer : peers) {
            peer.unbind(true);
        }
        this.sendStopEvent(torrents.second(), torrentHash);
    }

    private void sendStopEvent(LoadedTorrent loadedTorrent, String torrentHash) {
        if (loadedTorrent == null) {
            logger.info("Announceable torrent {} not found in storage after unsuccessful download attempt", (Object)torrentHash);
            return;
        }
        this.forceAnnounceAndLogError(loadedTorrent, AnnounceRequestMessage.RequestEvent.STOPPED);
    }

    public void setAnnounceInterval(int announceInterval) {
        this.announce.setAnnounceInterval(announceInterval);
    }

    public Collection<SharedTorrent> getTorrents() {
        return this.torrentsStorage.activeTorrents();
    }

    public URI getDefaultTrackerURI() {
        return this.announce.getDefaultTrackerURI();
    }

    public Set<SharingPeer> getPeers() {
        return new HashSet<SharingPeer>(this.peersStorage.getSharingPeers());
    }

    public void setMaxInConnectionsCount(int maxConnectionsCount) {
        this.myInConnectionAllower.setMyMaxConnectionCount(maxConnectionsCount);
    }

    public void setReceiveBufferSize(int newSize) {
        this.myReceiveBufferSize.set(newSize);
    }

    public void setSendBufferSize(int newSize) {
        this.mySendBufferSize.set(newSize);
    }

    public void setMaxOutConnectionsCount(int maxConnectionsCount) {
        this.myOutConnectionAllower.setMyMaxConnectionCount(maxConnectionsCount);
    }

    public void start(InetAddress ... bindAddresses) throws IOException {
        this.start(bindAddresses, 15, null, new SelectorFactoryImpl());
    }

    public void start(InetAddress[] bindAddresses, URI defaultTrackerURI) throws IOException {
        this.start(bindAddresses, 15, defaultTrackerURI, new SelectorFactoryImpl());
    }

    public Peer[] getSelfPeers(InetAddress[] bindAddresses) throws UnsupportedEncodingException {
        Peer self = this.peersStorage.getSelf();
        if (self == null) {
            return new Peer[0];
        }
        Peer[] result = new Peer[bindAddresses.length];
        for (int i = 0; i < bindAddresses.length; ++i) {
            InetAddress bindAddress = bindAddresses[i];
            Peer peer = new Peer(new InetSocketAddress(bindAddress.getHostAddress(), self.getPort()));
            peer.setTorrentHash(self.getHexInfoHash());
            if (i == 0) {
                peer.setPeerId(self.getPeerId());
            } else {
                String id = BITTORRENT_ID_PREFIX + UUID.randomUUID().toString().split("-")[4];
                byte[] idBytes = id.getBytes("ISO-8859-1");
                peer.setPeerId(ByteBuffer.wrap(idBytes));
            }
            result[i] = peer;
        }
        return result;
    }

    public void start(InetAddress[] bindAddresses, int announceIntervalSec, URI defaultTrackerURI, SelectorFactory selectorFactory) throws IOException {
        this.start(bindAddresses, announceIntervalSec, defaultTrackerURI, selectorFactory, new FirstAvailableChannel(6881, 6889));
    }

    public void start(InetAddress[] bindAddresses, int announceIntervalSec, URI defaultTrackerURI, SelectorFactory selectorFactory, ServerChannelRegister serverChannelRegister) throws IOException {
        this.myConnectionManager = new ConnectionManager(this, new SystemTimeService(), this.myInConnectionAllower, this.myOutConnectionAllower, selectorFactory, this.mySendBufferSize, this.myReceiveBufferSize);
        this.setSocketConnectionTimeout(100000, TimeUnit.MILLISECONDS);
        try {
            this.myConnectionManager.initAndRunWorker(serverChannelRegister);
        }
        catch (IOException e) {
            LoggerUtils.errorAndDebugDetails(logger, "error in initialization server channel", e);
            this.stop();
            return;
        }
        String id = BITTORRENT_ID_PREFIX + UUID.randomUUID().toString().split("-")[4];
        byte[] idBytes = id.getBytes("ISO-8859-1");
        Peer self = new Peer(new InetSocketAddress(this.myConnectionManager.getBindPort()), ByteBuffer.wrap(idBytes));
        this.peersStorage.setSelf(self);
        logger.info("BitTorrent client [{}] started and listening at {}:{}...", new Object[]{self.getShortHexPeerId(), self.getIp(), self.getPort()});
        this.announce.start(defaultTrackerURI, this, this.getSelfPeers(bindAddresses), announceIntervalSec);
        this.stop.set(false);
        this.myStarted = true;
    }

    public void stop() {
        this.stop(60, TimeUnit.SECONDS);
    }

    void stop(int timeout, TimeUnit timeUnit) {
        boolean wasStopped = this.stop.getAndSet(true);
        if (wasStopped) {
            return;
        }
        if (!this.myStarted) {
            return;
        }
        this.myConnectionManager.close();
        logger.trace("try stop announce thread...");
        this.announce.stop();
        logger.trace("announce thread is stopped");
        for (SharedTorrent torrent : this.torrentsStorage.activeTorrents()) {
            logger.trace("try close torrent {}", torrent);
            torrent.closeFully();
            if (torrent.isFinished()) {
                torrent.setClientState(ClientState.DONE);
                continue;
            }
            torrent.setClientState(ClientState.ERROR);
        }
        logger.debug("Closing all remaining peer connections...");
        for (SharingPeer peer : this.peersStorage.getSharingPeers()) {
            peer.unbind(true);
        }
        this.torrentsStorage.clear();
        logger.info("BitTorrent client signing off.");
    }

    public void setCleanupTimeout(int timeout, TimeUnit timeUnit) throws IllegalStateException {
        ConnectionManager connectionManager = this.myConnectionManager;
        if (connectionManager == null) {
            throw new IllegalStateException("connection manager is null");
        }
        connectionManager.setCleanupTimeout(timeUnit.toMillis(timeout));
    }

    public void setSocketConnectionTimeout(int timeout, TimeUnit timeUnit) throws IllegalStateException {
        ConnectionManager connectionManager = this.myConnectionManager;
        if (connectionManager == null) {
            throw new IllegalStateException("connection manager is null");
        }
        connectionManager.setSocketConnectionTimeout(timeUnit.toMillis(timeout));
    }

    public boolean isSeed(String hexInfoHash) {
        SharedTorrent t = this.torrentsStorage.getTorrent(hexInfoHash);
        return t != null && t.isComplete();
    }

    public List<SharingPeer> getPeersForTorrent(String torrentHash) {
        if (torrentHash == null) {
            return new ArrayList<SharingPeer>();
        }
        ArrayList<SharingPeer> result = new ArrayList<SharingPeer>();
        for (SharingPeer sharingPeer : this.peersStorage.getSharingPeers()) {
            if (!torrentHash.equals(sharingPeer.getHexInfoHash())) continue;
            result.add(sharingPeer);
        }
        return result;
    }

    public boolean isRunning() {
        return this.myStarted;
    }

    private Collection<SharingPeer> getConnectedPeers() {
        HashSet<SharingPeer> result = new HashSet<SharingPeer>();
        for (SharingPeer peer : this.peersStorage.getSharingPeers()) {
            if (!peer.isConnected()) continue;
            result.add(peer);
        }
        return result;
    }

    public boolean containsTorrentWithHash(String hash) {
        return this.torrentsStorage.hasTorrent(hash);
    }

    @Override
    public PeersStorage getPeersStorage() {
        return this.peersStorage;
    }

    @Override
    public TorrentsStorage getTorrentsStorage() {
        return this.torrentsStorage;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.myExecutorService;
    }

    public ExecutorService getPieceValidatorExecutor() {
        return this.myPieceValidatorExecutor;
    }

    @Override
    public ConnectionListener newChannelListener() {
        return new StateChannelListener(this);
    }

    @Override
    public SharingPeer createSharingPeer(String host, int port, ByteBuffer peerId, SharedTorrent torrent, ByteChannel channel, String clientIdentifier, int clientVersion) {
        return new SharingPeer(host, port, peerId, torrent, this.getConnectionManager(), this, channel, clientIdentifier, clientVersion);
    }

    @Override
    public TorrentLoader getTorrentLoader() {
        return this.myTorrentLoader;
    }

    @Override
    public void handleAnnounceResponse(int interval, int complete, int incomplete, String hexInfoHash) {
        SharedTorrent sharedTorrent = this.torrentsStorage.getTorrent(hexInfoHash);
        if (sharedTorrent != null) {
            sharedTorrent.setSeedersCount(complete);
            sharedTorrent.setLastAnnounceTime(System.currentTimeMillis());
        }
        this.setAnnounceInterval(interval);
    }

    @Override
    public void handleDiscoveredPeers(List<Peer> peers, String hexInfoHash) {
        PeerUID peerUID;
        if (peers.size() == 0) {
            return;
        }
        SharedTorrent torrent = this.torrentsStorage.getTorrent(hexInfoHash);
        if (torrent != null && torrent.isFinished()) {
            return;
        }
        LoadedTorrent announceableTorrent = this.torrentsStorage.getLoadedTorrent(hexInfoHash);
        if (announceableTorrent == null) {
            logger.info("announceable torrent {} is not found in storage. Maybe it was removed", (Object)hexInfoHash);
            return;
        }
        if (announceableTorrent.getPieceStorage().isFinished()) {
            return;
        }
        logger.debug("Got {} peer(s) ({}) for {} in tracker response", new Object[]{peers.size(), Arrays.toString(peers.toArray()), hexInfoHash});
        HashMap<PeerUID, Peer> uniquePeers = new HashMap<PeerUID, Peer>();
        for (Peer peer : peers) {
            peerUID = new PeerUID(peer.getAddress(), hexInfoHash);
            if (uniquePeers.containsKey(peerUID)) continue;
            uniquePeers.put(peerUID, peer);
        }
        for (Map.Entry entry : uniquePeers.entrySet()) {
            boolean alreadyConnectedToThisPeer;
            peerUID = (PeerUID)entry.getKey();
            Peer peer = (Peer)entry.getValue();
            boolean bl = alreadyConnectedToThisPeer = this.peersStorage.getSharingPeer(peerUID) != null;
            if (alreadyConnectedToThisPeer) {
                logger.debug("skipping peer {}, because we already connected to this peer", peer);
                continue;
            }
            OutgoingConnectionListener connectionListener = new OutgoingConnectionListener(this, announceableTorrent.getTorrentHash(), peer.getIp(), peer.getPort());
            logger.debug("trying to connect to the peer {}", peer);
            boolean connectTaskAdded = this.myConnectionManager.offerConnect(new ConnectTask(peer.getIp(), peer.getPort(), connectionListener, new SystemTimeService().now(), 10000), 1, TimeUnit.SECONDS);
            if (connectTaskAdded) continue;
            logger.info("can not connect to peer {}. Unable to add connect task to connection manager", peer);
        }
    }

    @Override
    public void handlePeerChoked(SharingPeer peer) {
    }

    @Override
    public void handlePeerReady(SharingPeer peer) {
    }

    @Override
    public void handlePieceAvailability(SharingPeer peer, Piece piece) {
    }

    @Override
    public void handleBitfieldAvailability(SharingPeer peer, BitSet availablePieces) {
    }

    @Override
    public void handlePieceSent(SharingPeer peer, Piece piece) {
    }

    @Override
    public void handlePieceCompleted(final SharingPeer peer, final Piece piece) throws IOException {
        final SharedTorrent torrent = peer.getTorrent();
        final String torrentHash = torrent.getHexInfoHash();
        try {
            Future<?> validationFuture = this.myPieceValidatorExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    CommunicationManager.this.validatePieceAsync(torrent, piece, torrentHash, peer);
                }
            });
            torrent.markCompletedAndAddValidationFuture(piece, validationFuture);
        }
        catch (RejectedExecutionException e) {
            torrent.markUncompleted(piece);
            LoggerUtils.warnWithMessageAndDebugDetails(logger, "Unable to submit validation task for torrent {}", torrentHash, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePieceAsync(SharedTorrent torrent, Piece piece, String torrentHash, SharingPeer peer) {
        try {
            Piece piece2 = piece;
            synchronized (piece2) {
                if (piece.isValid()) {
                    return;
                }
                piece.validate(torrent, piece);
                if (piece.isValid()) {
                    boolean isTorrentComplete;
                    torrent.notifyPieceDownloaded(piece, peer);
                    piece.finish();
                    PeerMessage.HaveMessage have = PeerMessage.HaveMessage.craft(piece.getIndex());
                    for (SharingPeer sharingPeer : this.getConnectedPeers()) {
                        if (!sharingPeer.getTorrent().getHexInfoHash().equals(torrentHash) || sharingPeer.getAvailablePieces().get(piece.getIndex())) continue;
                        sharingPeer.send(have);
                    }
                    peer.pieceDownloaded();
                    SharedTorrent sharedTorrent = torrent;
                    synchronized (sharedTorrent) {
                        boolean isCurrentPeerSeeder;
                        torrent.removeValidationFuture(piece);
                        boolean bl = isCurrentPeerSeeder = peer.getAvailablePieces().cardinality() == torrent.getPieceCount();
                        if (!isCurrentPeerSeeder && torrent.isAllPiecesOfPeerCompletedAndValidated(peer)) {
                            peer.notInteresting();
                        }
                        if (isTorrentComplete = torrent.isComplete()) {
                            logger.info("Download of {} complete.", (Object)torrent.getDirectoryName());
                            torrent.finish();
                        }
                    }
                    if (isTorrentComplete) {
                        LoadedTorrent loadedTorrent = this.torrentsStorage.getLoadedTorrent(torrentHash);
                        if (loadedTorrent == null) {
                            return;
                        }
                        AnnounceableInformation announceableInformation = loadedTorrent.createAnnounceableInformation();
                        if (!TorrentUtils.isTrackerLessInfo(announceableInformation)) {
                            try {
                                this.announce.getCurrentTrackerClient(announceableInformation).announceAllInterfaces(AnnounceRequestMessage.RequestEvent.COMPLETED, true, announceableInformation);
                            }
                            catch (AnnounceException e) {
                                logger.debug("unable to announce torrent {} on tracker {}", torrent, (Object)torrent.getAnnounce());
                            }
                        }
                        for (SharingPeer remote3 : this.getPeersForTorrent(torrentHash)) {
                            remote3.notInteresting();
                        }
                    }
                } else {
                    torrent.markUncompleted(piece);
                    logger.info("Downloaded piece #{} from {} was not valid ;-(. Trying another peer", piece.getIndex(), (Object)peer);
                    peer.getPoorlyAvailablePieces().set(piece.getIndex());
                }
            }
        }
        catch (Throwable e) {
            torrent.markUncompleted(piece);
            logger.warn("unhandled exception in piece {} validation task", e);
        }
        torrent.handlePeerReady(peer);
    }

    @Override
    public void handlePeerDisconnected(SharingPeer peer) {
        Peer p = new Peer(peer.getIp(), peer.getPort());
        p.setPeerId(peer.getPeerId());
        p.setTorrentHash(peer.getHexInfoHash());
        logger.trace("Peer {} disconnected, [{}/{}].", new Object[]{peer, this.getConnectedPeers().size(), this.peersStorage.getSharingPeers().size()});
        PeerUID peerUID = new PeerUID(peer.getAddress(), peer.getHexInfoHash());
        this.peersStorage.removeSharingPeer(peerUID);
    }

    @Override
    public void afterPeerRemoved(SharingPeer peer) {
        logger.trace("disconnected peer " + peer);
        this.torrentsStorage.peerDisconnected(peer.getHexInfoHash());
    }

    @Override
    public void handleIOException(SharingPeer peer, IOException ioe) {
        logger.debug("I/O problem occured when reading or writing piece data for peer {}: {}.", peer, (Object)ioe.getMessage());
        peer.unbind(true);
    }

    @Override
    public void handleNewPeerConnected(SharingPeer peer) {
    }

    public ConnectionManager getConnectionManager() throws IllegalStateException {
        ConnectionManager connectionManager = this.myConnectionManager;
        if (connectionManager == null) {
            throw new IllegalStateException("connection manager is null");
        }
        return connectionManager;
    }

    public boolean hasStop() {
        return this.stop.get();
    }
}

