/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.PeerInformation;
import com.turn.ttorrent.client.PieceInformation;
import com.turn.ttorrent.client.TorrentListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventDispatcher {
    private final List<TorrentListener> listeners = new CopyOnWriteArrayList<TorrentListener>();
    private final TorrentListener notifyer = this.createNotifyer();

    private TorrentListener createNotifyer() {
        return new TorrentListener(){

            @Override
            public void peerConnected(PeerInformation peerInformation) {
                for (TorrentListener listener : EventDispatcher.this.listeners) {
                    listener.peerConnected(peerInformation);
                }
            }

            @Override
            public void peerDisconnected(PeerInformation peerInformation) {
                for (TorrentListener listener : EventDispatcher.this.listeners) {
                    listener.peerDisconnected(peerInformation);
                }
            }

            @Override
            public void pieceDownloaded(PieceInformation pieceInformation, PeerInformation peerInformation) {
                for (TorrentListener listener : EventDispatcher.this.listeners) {
                    listener.pieceDownloaded(pieceInformation, peerInformation);
                }
            }

            @Override
            public void downloadComplete() {
                for (TorrentListener listener : EventDispatcher.this.listeners) {
                    listener.downloadComplete();
                }
            }

            @Override
            public void pieceReceived(PieceInformation pieceInformation, PeerInformation peerInformation) {
                for (TorrentListener listener : EventDispatcher.this.listeners) {
                    listener.pieceReceived(pieceInformation, peerInformation);
                }
            }

            @Override
            public void downloadFailed(Throwable cause) {
                for (TorrentListener listener : EventDispatcher.this.listeners) {
                    listener.downloadFailed(cause);
                }
            }

            @Override
            public void validationComplete(int validpieces, int totalpieces) {
                for (TorrentListener listener : EventDispatcher.this.listeners) {
                    listener.validationComplete(validpieces, totalpieces);
                }
            }
        };
    }

    TorrentListener multicaster() {
        return this.notifyer;
    }

    public boolean removeListener(TorrentListener listener) {
        return this.listeners.remove(listener);
    }

    public void addListener(TorrentListener listener) {
        this.listeners.add(listener);
    }
}

