/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.ClientState;
import com.turn.ttorrent.client.EventDispatcher;
import com.turn.ttorrent.client.Piece;
import com.turn.ttorrent.client.peer.PeerActivityListener;
import com.turn.ttorrent.client.peer.SharingPeer;
import com.turn.ttorrent.client.storage.PieceStorage;
import com.turn.ttorrent.client.strategy.EndGameStrategy;
import com.turn.ttorrent.client.strategy.EndGameStrategyImpl;
import com.turn.ttorrent.client.strategy.RequestStrategy;
import com.turn.ttorrent.client.strategy.RequestStrategyImplAnyInteresting;
import com.turn.ttorrent.client.strategy.RequestsCollection;
import com.turn.ttorrent.client.strategy.RequestsCollectionImpl;
import com.turn.ttorrent.common.Optional;
import com.turn.ttorrent.common.TorrentCreator;
import com.turn.ttorrent.common.TorrentFile;
import com.turn.ttorrent.common.TorrentInfo;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentParser;
import com.turn.ttorrent.common.TorrentStatistic;
import com.turn.ttorrent.common.TorrentUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SharedTorrent
implements PeerActivityListener,
TorrentMetadata,
TorrentInfo {
    private static final Logger logger = TorrentLoggerFactory.getLogger(SharedTorrent.class);
    private static final RequestStrategy DEFAULT_REQUEST_STRATEGY = new RequestStrategyImplAnyInteresting();
    private static final float ENG_GAME_COMPLETION_RATIO = 0.95f;
    private static final int END_GAME_STATIC_PIECES_COUNT = 20;
    private static final long END_GAME_INVOCATION_PERIOD_MS = 2000L;
    private final TorrentStatistic myTorrentStatistic;
    private long myLastAnnounceTime = -1L;
    private int mySeedersCount = 0;
    private final PieceStorage pieceStorage;
    private boolean isFileChannelOpen = false;
    private final Map<Integer, Future<?>> myValidationFutures;
    private final TorrentMetadata myTorrentMetadata;
    private final long myTorrentTotalSize;
    private final int pieceLength;
    private final ByteBuffer piecesHashes;
    private boolean initialized;
    private Piece[] pieces;
    private final BitSet completedPieces;
    private final BitSet requestedPieces;
    private final RequestStrategy myRequestStrategy;
    private final EventDispatcher eventDispatcher;
    private final List<SharingPeer> myDownloaders = new CopyOnWriteArrayList<SharingPeer>();
    private final EndGameStrategy endGameStrategy = new EndGameStrategyImpl(2);
    private volatile long endGameEnabledOn = -1L;
    private volatile ClientState clientState = ClientState.WAITING;
    private static final int MAX_VALIDATION_TASK_COUNT = 200;
    private static final int MAX_REQUESTED_PIECES_PER_TORRENT = 100;

    public SharedTorrent(TorrentMetadata torrentMetadata, PieceStorage pieceStorage, RequestStrategy requestStrategy, TorrentStatistic torrentStatistic, EventDispatcher eventDispatcher) {
        this.myTorrentMetadata = torrentMetadata;
        this.pieceStorage = pieceStorage;
        this.eventDispatcher = eventDispatcher;
        this.myTorrentStatistic = torrentStatistic;
        this.myValidationFutures = new HashMap();
        long totalSize = 0L;
        for (TorrentFile torrentFile : this.myTorrentMetadata.getFiles()) {
            totalSize += torrentFile.size;
        }
        this.myTorrentTotalSize = totalSize;
        this.myRequestStrategy = requestStrategy;
        this.pieceLength = this.myTorrentMetadata.getPieceLength();
        this.piecesHashes = ByteBuffer.wrap(this.myTorrentMetadata.getPiecesHashes());
        if ((long)(this.piecesHashes.capacity() / 20) * (long)this.pieceLength < this.myTorrentTotalSize) {
            throw new IllegalArgumentException("Torrent size does not match the number of pieces and the piece size!");
        }
        this.initialized = false;
        this.pieces = new Piece[0];
        this.completedPieces = new BitSet(torrentMetadata.getPiecesCount());
        this.requestedPieces = new BitSet();
    }

    public static SharedTorrent fromFile(File source, PieceStorage pieceStorage, TorrentStatistic torrentStatistic) throws IOException {
        byte[] data = FileUtils.readFileToByteArray(source);
        TorrentMetadata torrentMetadata = new TorrentParser().parse(data);
        return new SharedTorrent(torrentMetadata, pieceStorage, DEFAULT_REQUEST_STRATEGY, torrentStatistic, new EventDispatcher());
    }

    private synchronized void closeFileChannelIfNecessary() throws IOException {
        if (this.isFileChannelOpen && this.myDownloaders.size() == 0) {
            logger.debug("Closing file  channel for {} if necessary. Downloaders: {}", (Object)this.getHexInfoHash(), (Object)this.myDownloaders.size());
            this.pieceStorage.close();
            this.isFileChannelOpen = false;
        }
    }

    @Override
    public long getUploaded() {
        return this.myTorrentStatistic.getUploadedBytes();
    }

    @Override
    public long getDownloaded() {
        return this.myTorrentStatistic.getDownloadedBytes();
    }

    @Override
    public long getLeft() {
        return this.myTorrentStatistic.getLeftBytes();
    }

    public int getSeedersCount() {
        return this.mySeedersCount;
    }

    public void setSeedersCount(int seedersCount) {
        this.mySeedersCount = seedersCount;
    }

    public long getLastAnnounceTime() {
        return this.myLastAnnounceTime;
    }

    public void setLastAnnounceTime(long lastAnnounceTime) {
        this.myLastAnnounceTime = lastAnnounceTime;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void stop() {
    }

    public synchronized void init() throws InterruptedException, IOException {
        this.setClientState(ClientState.VALIDATING);
        if (this.isInitialized()) {
            throw new IllegalStateException("Torrent was already initialized!");
        }
        this.hashSingleThread();
        this.initialized = true;
    }

    private void initPieces() {
        int nPieces = (int)Math.ceil((double)this.myTorrentTotalSize / (double)this.pieceLength);
        this.pieces = new Piece[nPieces];
        this.piecesHashes.clear();
    }

    private void hashSingleThread() {
        this.initPieces();
        logger.debug("Analyzing local data for {} with {} threads...", (Object)this.myTorrentMetadata.getDirectoryName(), (Object)TorrentCreator.HASHING_THREADS_COUNT);
        for (int idx = 0; idx < this.pieces.length; ++idx) {
            Piece piece;
            byte[] hash = new byte[20];
            this.piecesHashes.get(hash);
            long off = (long)idx * (long)this.pieceLength;
            long len = Math.min(this.myTorrentTotalSize - off, (long)this.pieceLength);
            this.pieces[idx] = piece = new Piece(this.pieceStorage, idx, len, hash);
            piece.setValid(this.pieceStorage.getAvailablePieces().get(idx));
            if (!piece.isValid()) continue;
            this.completedPieces.set(piece.getIndex());
        }
    }

    public synchronized void close() {
        logger.trace("Closing torrent", (Object)this.myTorrentMetadata.getDirectoryName());
        try {
            this.pieceStorage.close();
            this.isFileChannelOpen = false;
        }
        catch (IOException ioe) {
            logger.error("Error closing torrent byte storage: {}", (Object)ioe.getMessage());
        }
    }

    public synchronized void closeFully() {
        logger.trace("Closing torrent", (Object)this.myTorrentMetadata.getDirectoryName());
        try {
            this.pieceStorage.closeFully();
            this.isFileChannelOpen = false;
        }
        catch (IOException ioe) {
            logger.error("Error closing torrent byte storage: {}", (Object)ioe.getMessage());
        }
    }

    public Piece getPiece(int index) {
        if (this.pieces == null) {
            throw new IllegalStateException("Torrent not initialized yet.");
        }
        if (index >= this.pieces.length) {
            throw new IllegalArgumentException("Invalid piece index!");
        }
        return this.pieces[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet getAvailablePieces() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Torrent not yet initialized!");
        }
        BitSet availablePieces = new BitSet(this.pieces.length);
        Piece[] pieceArray = this.pieces;
        synchronized (this.pieces) {
            for (Piece piece : this.pieces) {
                if (!piece.available()) continue;
                availablePieces.set(piece.getIndex());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return availablePieces;
        }
    }

    public BitSet getCompletedPieces() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Torrent not yet initialized!");
        }
        return this.pieceStorage.getAvailablePieces();
    }

    public synchronized boolean isComplete() {
        return this.pieces.length > 0 && this.pieceStorage.getAvailablePieces().cardinality() == this.myTorrentMetadata.getPiecesCount();
    }

    public synchronized void finish() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Torrent not yet initialized!");
        }
        if (!this.isComplete()) {
            throw new IllegalStateException("Torrent download is not complete!");
        }
        this.eventDispatcher.multicaster().downloadComplete();
        this.setClientState(ClientState.SEEDING);
    }

    public boolean isFinished() {
        return this.pieceStorage.getAvailablePieces().cardinality() == this.myTorrentMetadata.getPiecesCount();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    public synchronized void markCompleted(Piece piece) {
        if (this.completedPieces.get(piece.getIndex())) {
            return;
        }
        this.myTorrentStatistic.addLeft(-piece.size());
        this.completedPieces.set(piece.getIndex());
        if (this.completedPieces.cardinality() == this.getPiecesCount()) {
            logger.info("all pieces are received for torrent {}. Validating...", this);
        }
    }

    public synchronized void markUncompleted(Piece piece) {
        if (!this.completedPieces.get(piece.getIndex())) {
            return;
        }
        this.removeValidationFuture(piece);
        this.myTorrentStatistic.addLeft(piece.size());
        this.completedPieces.clear(piece.getIndex());
    }

    public synchronized void removeValidationFuture(Piece piece) {
        this.myValidationFutures.remove(piece.getIndex());
    }

    public void notifyPieceDownloaded(Piece piece, SharingPeer peer) {
        this.eventDispatcher.multicaster().pieceDownloaded(piece, peer);
    }

    @Override
    public synchronized void handlePeerChoked(SharingPeer peer) {
        Set<Piece> pieces = peer.getRequestedPieces();
        if (pieces.size() > 0) {
            for (Piece piece : pieces) {
                this.requestedPieces.set(piece.getIndex(), false);
            }
        }
        logger.trace("Peer {} choked, we now have {} outstanding request(s): {}.", new Object[]{peer, this.requestedPieces.cardinality(), this.requestedPieces});
    }

    @Override
    public void handlePeerReady(SharingPeer peer) {
        this.initIfNecessary(peer);
        RequestsCollection requestsCollection = this.getRequestsCollection(peer);
        requestsCollection.sendAllRequests();
    }

    @NotNull
    private synchronized RequestsCollection getRequestsCollection(SharingPeer peer) {
        boolean turnOnEndGame;
        if (this.myValidationFutures.size() > 200) {
            return RequestsCollection.Empty.INSTANCE;
        }
        if (this.requestedPieces.cardinality() > 100) {
            return RequestsCollection.Empty.INSTANCE;
        }
        int completedAndValidated = this.pieceStorage.getAvailablePieces().cardinality();
        boolean bl = turnOnEndGame = (float)completedAndValidated > (float)this.getPiecesCount() * 0.95f || completedAndValidated > this.getPiecesCount() - 20;
        if (turnOnEndGame) {
            long now = System.currentTimeMillis();
            if (now - 2000L > this.endGameEnabledOn) {
                this.endGameEnabledOn = now;
                logger.info("Running end-game mode, currently available {}/{} pieces", this.pieceStorage.getAvailablePieces().cardinality(), (Object)this.getPieceCount());
                return this.endGameStrategy.collectRequests(this.pieces, this.myDownloaders);
            }
            return RequestsCollection.Empty.INSTANCE;
        }
        BitSet interesting = peer.getAvailablePieces();
        interesting.andNot(this.completedPieces);
        interesting.andNot(this.requestedPieces);
        int maxRequestingPieces = Math.min(10, interesting.cardinality());
        HashMap<Piece, List<SharingPeer>> toRequest = new HashMap<Piece, List<SharingPeer>>();
        for (int currentlyDownloading = peer.getDownloadingPiecesCount(); currentlyDownloading < maxRequestingPieces && peer.isConnected(); ++currentlyDownloading) {
            if (interesting.cardinality() == 0) {
                return RequestsCollection.Empty.INSTANCE;
            }
            Piece chosen = this.myRequestStrategy.choosePiece(interesting, this.pieces);
            if (chosen == null) {
                logger.info("chosen piece is null");
                break;
            }
            this.requestedPieces.set(chosen.getIndex());
            toRequest.put(chosen, Collections.singletonList(peer));
            interesting.clear(chosen.getIndex());
        }
        return new RequestsCollectionImpl(toRequest);
    }

    public synchronized void initIfNecessary(SharingPeer peer) {
        if (!this.isInitialized()) {
            try {
                this.init();
            }
            catch (InterruptedException e) {
                logger.info("Interrupted init", e);
                peer.unbind(true);
                return;
            }
            catch (IOException e) {
                logger.info("IOE during init", e);
                peer.unbind(true);
                return;
            }
        }
    }

    @Override
    public void handlePieceAvailability(SharingPeer peer, Piece piece) {
        boolean isPeerInteresting;
        boolean bl = isPeerInteresting = !this.completedPieces.get(piece.getIndex()) && !this.requestedPieces.get(piece.getIndex());
        if (isPeerInteresting) {
            peer.interesting();
        }
        piece.seenAt(peer);
        logger.trace("Peer {} contributes {} piece(s) [{}/{}/{}].", new Object[]{peer, peer.getAvailablePieces().cardinality(), this.completedPieces.cardinality(), this.getAvailablePieces().cardinality(), this.pieces.length});
        if (!peer.isChoked() && peer.isInteresting() && !peer.isDownloading()) {
            this.handlePeerReady(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBitfieldAvailability(SharingPeer peer, BitSet availablePieces) {
        BitSet interesting = (BitSet)availablePieces.clone();
        SharedTorrent sharedTorrent = this;
        synchronized (sharedTorrent) {
            interesting.andNot(this.completedPieces);
            interesting.andNot(this.requestedPieces);
        }
        int i = availablePieces.nextSetBit(0);
        while (i >= 0) {
            this.pieces[i].seenAt(peer);
            i = availablePieces.nextSetBit(i + 1);
        }
        if (interesting.cardinality() == 0) {
            peer.notInteresting();
        } else {
            peer.interesting();
        }
        logger.debug("Peer {} contributes {} piece(s), total pieces count: {}.", new Object[]{peer, availablePieces.cardinality(), this.myTorrentMetadata.getPiecesCount()});
    }

    public int getDownloadersCount() {
        return this.myDownloaders.size();
    }

    @Override
    public void afterPeerRemoved(SharingPeer peer) {
    }

    @Override
    public void handlePieceSent(SharingPeer peer, Piece piece) {
        logger.trace("Completed upload of {} to {}.", piece, (Object)peer);
        this.myTorrentStatistic.addUploaded(piece.size());
    }

    @Override
    public void handlePieceCompleted(SharingPeer peer, Piece piece) throws IOException {
        this.myTorrentStatistic.addDownloaded(piece.size());
        this.requestedPieces.set(piece.getIndex(), false);
        logger.trace("We now have {} piece(s) and {} outstanding request(s): {}", new Object[]{this.completedPieces.cardinality(), this.requestedPieces.cardinality(), this.requestedPieces});
    }

    @Override
    public synchronized void handlePeerDisconnected(SharingPeer peer) {
        BitSet availablePieces = peer.getAvailablePieces();
        int i = availablePieces.nextSetBit(0);
        while (i >= 0) {
            this.pieces[i].noLongerAt(peer);
            i = availablePieces.nextSetBit(i + 1);
        }
        Set<Piece> requested = peer.getRequestedPieces();
        if (requested != null) {
            for (Piece piece : requested) {
                this.requestedPieces.set(piece.getIndex(), false);
            }
        }
        this.myDownloaders.remove(peer);
        try {
            this.closeFileChannelIfNecessary();
        }
        catch (IOException e) {
            logger.info("I/O error on attempt to close file storage: " + e.toString());
        }
        logger.debug("Peer {} went away with {} piece(s) [{}/{}].", new Object[]{peer, availablePieces.cardinality(), this.completedPieces.cardinality(), this.pieces.length});
        logger.trace("We now have {} piece(s) and {} outstanding request(s): {}", new Object[]{this.completedPieces.cardinality(), this.requestedPieces.cardinality(), this.requestedPieces});
        this.eventDispatcher.multicaster().peerDisconnected(peer);
    }

    @Override
    public synchronized void handleIOException(SharingPeer peer, IOException ioe) {
        this.eventDispatcher.multicaster().downloadFailed(ioe);
    }

    @Override
    public synchronized void handleNewPeerConnected(SharingPeer peer) {
        this.initIfNecessary(peer);
        this.eventDispatcher.multicaster().peerConnected(peer);
    }

    public String toString() {
        return "SharedTorrent{" + Arrays.toString(TorrentUtils.getTorrentFileNames(this.myTorrentMetadata).toArray()) + "}";
    }

    @Override
    public String getDirectoryName() {
        return this.myTorrentMetadata.getDirectoryName();
    }

    @Override
    public List<TorrentFile> getFiles() {
        return this.myTorrentMetadata.getFiles();
    }

    @Override
    @Nullable
    public List<List<String>> getAnnounceList() {
        return this.myTorrentMetadata.getAnnounceList();
    }

    @Override
    @Nullable
    public String getAnnounce() {
        return this.myTorrentMetadata.getAnnounce();
    }

    @Override
    public Optional<Long> getCreationDate() {
        return this.myTorrentMetadata.getCreationDate();
    }

    @Override
    public Optional<String> getComment() {
        return this.myTorrentMetadata.getComment();
    }

    @Override
    public Optional<String> getCreatedBy() {
        return this.myTorrentMetadata.getCreatedBy();
    }

    @Override
    public int getPieceLength() {
        return this.myTorrentMetadata.getPieceLength();
    }

    @Override
    public byte[] getPiecesHashes() {
        return this.myTorrentMetadata.getPiecesHashes();
    }

    @Override
    public boolean isPrivate() {
        return this.myTorrentMetadata.isPrivate();
    }

    @Override
    public int getPiecesCount() {
        return this.myTorrentMetadata.getPiecesCount();
    }

    @Override
    public byte[] getInfoHash() {
        return this.myTorrentMetadata.getInfoHash();
    }

    @Override
    public String getHexInfoHash() {
        return this.myTorrentMetadata.getHexInfoHash();
    }

    @Override
    public int getPieceCount() {
        return this.getPiecesCount();
    }

    @Override
    public long getPieceSize(int pieceIdx) {
        return this.getPieceLength();
    }

    public synchronized void savePieceAndValidate(Piece p) throws IOException {
    }

    public synchronized void markCompletedAndAddValidationFuture(Piece piece, Future<?> validationFuture) {
        this.markCompleted(piece);
        this.myValidationFutures.put(piece.getIndex(), validationFuture);
    }

    public synchronized boolean isAllPiecesOfPeerCompletedAndValidated(SharingPeer peer) {
        BitSet availablePieces = peer.getAvailablePieces();
        for (Piece piece : this.pieces) {
            boolean peerHaveCurrentPiece = availablePieces.get(piece.getIndex());
            if (!peerHaveCurrentPiece) continue;
            if (!this.completedPieces.get(piece.getIndex())) {
                return false;
            }
            if (this.myValidationFutures.get(piece.getIndex()) == null) continue;
            return false;
        }
        return true;
    }

    public void addConnectedPeer(SharingPeer sharingPeer) {
        this.myDownloaders.add(sharingPeer);
    }
}

