/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.announce;

import com.turn.ttorrent.bcodec.BDecoder;
import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.client.announce.TrackerClient;
import com.turn.ttorrent.common.AnnounceableInformation;
import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.protocol.AnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.http.HTTPAnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.http.HTTPAnnounceResponseMessage;
import com.turn.ttorrent.common.protocol.http.HTTPTrackerMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class HTTPTrackerClient
extends TrackerClient {
    protected static final Logger logger = TorrentLoggerFactory.getLogger(HTTPTrackerClient.class);

    public HTTPTrackerClient(List<Peer> peers, URI tracker) {
        super(peers, tracker);
    }

    @Override
    public void announce(AnnounceRequestMessage.RequestEvent event, boolean inhibitEvents, AnnounceableInformation torrentInfo, List<Peer> adresses) throws AnnounceException {
        this.logAnnounceRequest(event, torrentInfo);
        final ArrayList trackerResponses = new ArrayList();
        for (Peer address : adresses) {
            final URL target = this.encodeAnnounceToURL(event, torrentInfo, address);
            try {
                this.sendAnnounce(target, "GET", new ResponseParser(){

                    @Override
                    public void parse(InputStream inputStream, int responseCode) throws IOException, TrackerMessage.MessageValidationException {
                        if (responseCode != 200) {
                            logger.info("received not http 200 code from tracker for request " + target);
                            return;
                        }
                        trackerResponses.add(HTTPTrackerMessage.parse(inputStream));
                    }
                });
            }
            catch (ConnectException e) {
                throw new AnnounceException(e.getMessage(), e);
            }
        }
        if (trackerResponses.size() > 0) {
            HTTPTrackerMessage message = (HTTPTrackerMessage)trackerResponses.get(0);
            this.handleTrackerAnnounceResponse(message, inhibitEvents, torrentInfo.getHexInfoHash());
        }
    }

    @Override
    protected void multiAnnounce(AnnounceRequestMessage.RequestEvent event, boolean inhibitEvent, List<? extends AnnounceableInformation> torrents, List<Peer> addresses) throws AnnounceException, ConnectException {
        URL trackerUrl;
        ArrayList trackerResponses = new ArrayList();
        try {
            trackerUrl = this.tracker.toURL();
        }
        catch (MalformedURLException e) {
            throw new AnnounceException("Invalid tracker URL " + this.tracker, e);
        }
        for (Peer address : addresses) {
            StringBuilder body = new StringBuilder();
            for (AnnounceableInformation announceableInformation : torrents) {
                body.append(this.encodeAnnounceToURL(event, announceableInformation, address)).append("\n");
            }
            final ArrayList responsesForCurrentIp = new ArrayList();
            final String string = body.substring(0, body.length() - 1);
            this.sendAnnounce(trackerUrl, string, "POST", new ResponseParser(){

                @Override
                public void parse(InputStream inputStream, int responseCode) throws IOException, TrackerMessage.MessageValidationException {
                    if (responseCode != 200) {
                        logger.info("received {} code from tracker for multi announce request.", responseCode);
                        logger.debug(string);
                        return;
                    }
                    BEValue bdecode = BDecoder.bdecode(inputStream);
                    if (bdecode == null) {
                        logger.info("tracker sent bad response for multi announce message.");
                        logger.debug(string);
                        return;
                    }
                    List<BEValue> list = bdecode.getList();
                    for (BEValue value : list) {
                        responsesForCurrentIp.add(HTTPTrackerMessage.parse(value));
                    }
                }
            });
            if (responsesForCurrentIp.isEmpty()) continue;
            trackerResponses.add(responsesForCurrentIp);
        }
        if (trackerResponses.size() > 0) {
            List messages = (List)trackerResponses.get(0);
            for (HTTPTrackerMessage message : messages) {
                if (!(message instanceof HTTPAnnounceResponseMessage)) {
                    logger.info("Incorrect instance of message {}. Skipping...", message);
                    continue;
                }
                String hexInfoHash = ((HTTPAnnounceResponseMessage)message).getHexInfoHash();
                try {
                    this.handleTrackerAnnounceResponse(message, inhibitEvent, hexInfoHash);
                }
                catch (AnnounceException announceException) {
                    LoggerUtils.errorAndDebugDetails(logger, "Unable to process tracker response {}", message, announceException);
                }
            }
        }
    }

    private URL encodeAnnounceToURL(AnnounceRequestMessage.RequestEvent event, AnnounceableInformation torrentInfo, Peer peer) throws AnnounceException {
        URL result;
        try {
            HTTPAnnounceRequestMessage request = this.buildAnnounceRequest(event, torrentInfo, peer);
            result = request.buildAnnounceURL(this.tracker.toURL());
        }
        catch (MalformedURLException mue) {
            throw new AnnounceException("Invalid announce URL (" + mue.getMessage() + ")", mue);
        }
        catch (TrackerMessage.MessageValidationException mve) {
            throw new AnnounceException("Announce request creation violated expected protocol (" + mve.getMessage() + ")", mve);
        }
        catch (IOException ioe) {
            throw new AnnounceException("Error building announce request (" + ioe.getMessage() + ")", ioe);
        }
        return result;
    }

    private void sendAnnounce(URL url, String method, ResponseParser parser) throws AnnounceException, ConnectException {
        this.sendAnnounce(url, "", method, parser);
    }

    private void sendAnnounce(URL url, String body, String method, ResponseParser parser) throws AnnounceException, ConnectException {
        InputStream in;
        HttpURLConnection conn;
        block18: {
            conn = null;
            in = null;
            try {
                conn = (HttpURLConnection)this.openConnectionCheckRedirects(url, body, method);
                in = conn.getInputStream();
            }
            catch (IOException ioe) {
                if (conn == null) break block18;
                in = conn.getErrorStream();
            }
        }
        if (in == null) {
            throw new ConnectException("No response or unreachable tracker!");
        }
        try {
            parser.parse(in, conn.getResponseCode());
        }
        catch (IOException ioe) {
            throw new AnnounceException("Error reading tracker response!", ioe);
        }
        catch (TrackerMessage.MessageValidationException mve) {
            throw new AnnounceException("Tracker message violates expected protocol (" + mve.getMessage() + ")", mve);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                logger.info("Problem ensuring error stream closed!");
                logger.debug("Problem ensuring error stream closed!", ioe);
            }
            InputStream err = conn.getErrorStream();
            if (err != null) {
                try {
                    err.close();
                }
                catch (IOException ioe) {
                    logger.info("Problem ensuring error stream closed!");
                    logger.debug("Problem ensuring error stream closed!", ioe);
                }
            }
        }
    }

    private URLConnection openConnectionCheckRedirects(URL url, String body, String method) throws IOException {
        boolean needRedirect;
        int redirects = 0;
        URLConnection connection = url.openConnection();
        boolean firstIteration = true;
        do {
            int stat;
            needRedirect = false;
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            HttpURLConnection http = null;
            if (connection instanceof HttpURLConnection) {
                http = (HttpURLConnection)connection;
                http.setInstanceFollowRedirects(false);
            }
            if (http == null) continue;
            if (firstIteration) {
                firstIteration = false;
                http.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
                http.setRequestMethod(method);
                if (!body.isEmpty()) {
                    connection.setDoOutput(true);
                    connection.getOutputStream().write(body.getBytes("UTF-8"));
                }
            }
            if ((stat = http.getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String newLocation = http.getHeaderField("Location");
            URL target = newLocation == null ? null : new URL(base, newLocation);
            http.disconnect();
            if (redirects >= 5) {
                throw new IOException("too many redirects");
            }
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https")) {
                throw new IOException("illegal URL redirect or protocol");
            }
            needRedirect = true;
            connection = target.openConnection();
            ++redirects;
        } while (needRedirect);
        return connection;
    }

    private HTTPAnnounceRequestMessage buildAnnounceRequest(AnnounceRequestMessage.RequestEvent event, AnnounceableInformation torrentInfo, Peer peer) throws IOException, TrackerMessage.MessageValidationException {
        long uploaded = torrentInfo.getUploaded();
        long downloaded = torrentInfo.getDownloaded();
        long left = torrentInfo.getLeft();
        return HTTPAnnounceRequestMessage.craft(torrentInfo.getInfoHash(), peer.getPeerIdArray(), peer.getPort(), uploaded, downloaded, left, true, false, event, peer.getIp(), 50);
    }

    private static interface ResponseParser {
        public void parse(InputStream var1, int var2) throws IOException, TrackerMessage.MessageValidationException;
    }
}

