/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.peer;

import java.io.Serializable;
import java.util.Comparator;

public class Rate
implements Comparable<Rate> {
    public static final Comparator<Rate> RATE_COMPARATOR = new RateComparator();
    private long bytes = 0L;
    private long reset = 0L;
    private long last = 0L;

    public synchronized void add(long count) {
        this.bytes += count;
        if (this.reset == 0L) {
            this.reset = System.currentTimeMillis();
        }
        this.last = System.currentTimeMillis();
    }

    public synchronized float get() {
        if (this.last - this.reset == 0L) {
            return 0.0f;
        }
        return (float)this.bytes / ((float)(this.last - this.reset) / 1000.0f);
    }

    public synchronized void reset() {
        this.bytes = 0L;
        this.last = this.reset = System.currentTimeMillis();
    }

    @Override
    public int compareTo(Rate other) {
        return RATE_COMPARATOR.compare(this, other);
    }

    private static class RateComparator
    implements Comparator<Rate>,
    Serializable {
        private static final long serialVersionUID = 72460233003600L;

        private RateComparator() {
        }

        @Override
        public int compare(Rate a, Rate b) {
            if (a.get() > b.get()) {
                return 1;
            }
            return -1;
        }
    }
}

