/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.storage;

import com.turn.ttorrent.client.storage.PieceStorage;
import com.turn.ttorrent.client.storage.PieceStorageFactory;
import com.turn.ttorrent.client.storage.PieceStorageImpl;
import com.turn.ttorrent.client.storage.TorrentByteStorage;
import com.turn.ttorrent.common.TorrentFile;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;

public class FairPieceStorageFactory
implements PieceStorageFactory {
    public static final FairPieceStorageFactory INSTANCE = new FairPieceStorageFactory();

    private FairPieceStorageFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PieceStorage createStorage(TorrentMetadata metadata, TorrentByteStorage byteStorage) throws IOException {
        long totalSize = 0L;
        for (TorrentFile file : metadata.getFiles()) {
            totalSize += file.size;
        }
        byteStorage.open(false);
        BitSet availablePieces = new BitSet(metadata.getPiecesCount());
        try {
            if (!byteStorage.isBlank()) {
                int pieceLength = metadata.getPieceLength();
                for (int i = 0; i < metadata.getPiecesCount(); ++i) {
                    long position;
                    int len = totalSize - (position = (long)i * (long)pieceLength) > (long)pieceLength ? pieceLength : (int)(totalSize - position);
                    if (byteStorage.isBlank(position, len)) continue;
                    ByteBuffer buffer = ByteBuffer.allocate(len);
                    byteStorage.read(buffer, position);
                    byte[] expectedHash = Arrays.copyOfRange(metadata.getPiecesHashes(), i * 20, (i + 1) * 20);
                    byte[] actualHash = TorrentUtils.calculateSha1Hash(buffer.array());
                    if (!Arrays.equals(expectedHash, actualHash)) continue;
                    availablePieces.set(i);
                }
            }
        }
        finally {
            byteStorage.close();
        }
        return new PieceStorageImpl(byteStorage, availablePieces, metadata.getPiecesCount(), metadata.getPieceLength());
    }
}

