/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common;

import com.turn.ttorrent.common.AnnounceableInformation;
import com.turn.ttorrent.common.TorrentFile;
import com.turn.ttorrent.common.TorrentMetadata;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public final class TorrentUtils {
    private static final char[] HEX_SYMBOLS = "0123456789ABCDEF".toCharArray();

    public static byte[] calculateSha1Hash(byte[] data) {
        return DigestUtils.sha1(data);
    }

    public static String byteArrayToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_SYMBOLS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_SYMBOLS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isTrackerLessInfo(AnnounceableInformation information) {
        return information.getAnnounce() == null && information.getAnnounceList() == null;
    }

    public static List<String> getTorrentFileNames(TorrentMetadata metadata) {
        ArrayList<String> result = new ArrayList<String>();
        for (TorrentFile torrentFile : metadata.getFiles()) {
            result.add(torrentFile.getRelativePathAsString());
        }
        return result;
    }
}

