/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.creation;

import com.turn.ttorrent.common.creation.DataSourceHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class CommonHashingCalculator {
    static final CommonHashingCalculator INSTANCE = new CommonHashingCalculator();

    CommonHashingCalculator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Long> processDataSources(List<DataSourceHolder> sources, int pieceSize, Processor processor) throws IOException {
        ArrayList<Long> sourcesSizes = new ArrayList<Long>();
        byte[] buffer = new byte[pieceSize];
        int read = 0;
        for (DataSourceHolder source : sources) {
            long streamSize = 0L;
            InputStream stream = source.getStream();
            try {
                int readFromStream;
                while ((readFromStream = stream.read(buffer, read, buffer.length - read)) >= 0) {
                    streamSize += (long)readFromStream;
                    if ((read += readFromStream) != buffer.length) continue;
                    processor.process(buffer);
                    read = 0;
                }
            }
            finally {
                source.close();
                sourcesSizes.add(streamSize);
            }
        }
        if (read > 0) {
            processor.process(Arrays.copyOf(buffer, read));
        }
        return sourcesSizes;
    }

    static interface Processor {
        public void process(byte[] var1);
    }
}

