/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol;

public interface AnnounceRequestMessage {
    public static final int DEFAULT_NUM_WANT = 50;

    public byte[] getInfoHash();

    public String getHexInfoHash();

    public byte[] getPeerId();

    public String getHexPeerId();

    public int getPort();

    public long getUploaded();

    public long getDownloaded();

    public long getLeft();

    public boolean isCompact();

    public boolean canOmitPeerId();

    public RequestEvent getEvent();

    public String getIp();

    public int getNumWant();

    public String getKey();

    public String getTrackerId();

    public static enum RequestEvent {
        NONE(0),
        COMPLETED(1),
        STARTED(2),
        STOPPED(3);

        private final int id;

        private RequestEvent(int id) {
            this.id = id;
        }

        public String getEventName() {
            return this.name().toLowerCase();
        }

        public int getId() {
            return this.id;
        }

        public static RequestEvent getByName(String name) {
            for (RequestEvent type : RequestEvent.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }

        public static RequestEvent getById(int id) {
            for (RequestEvent type : RequestEvent.values()) {
                if (type.getId() != id) continue;
                return type;
            }
            return null;
        }
    }
}

