/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.network;

import com.turn.ttorrent.network.ConnectionListener;
import com.turn.ttorrent.network.ReadAttachment;
import com.turn.ttorrent.network.TimeoutAttachment;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;

public class ConnectTask
implements TimeoutAttachment,
ReadAttachment {
    private long lastCommunicationTime;
    private final int myTimeoutMillis;
    private final String myHost;
    private final int myPort;
    private final ConnectionListener myConnectionListener;

    public ConnectTask(String host, int port, ConnectionListener connectionListener, long lastCommunicationTime, int timeoutMillis) {
        this.myHost = host;
        this.myPort = port;
        this.myConnectionListener = connectionListener;
        this.myTimeoutMillis = timeoutMillis;
        this.lastCommunicationTime = lastCommunicationTime;
    }

    public String getHost() {
        return this.myHost;
    }

    public int getPort() {
        return this.myPort;
    }

    @Override
    public ConnectionListener getConnectionListener() {
        return this.myConnectionListener;
    }

    public String toString() {
        return "ConnectTask{myHost='" + this.myHost + '\'' + ", myPort=" + this.myPort + '}';
    }

    @Override
    public boolean isTimeoutElapsed(long currentTimeMillis) {
        long minTimeForKeepAlive = currentTimeMillis - (long)this.myTimeoutMillis;
        return minTimeForKeepAlive > this.lastCommunicationTime;
    }

    @Override
    public void communicatedNow(long currentTimeMillis) {
        this.lastCommunicationTime = currentTimeMillis;
    }

    @Override
    public void onTimeoutElapsed(SocketChannel channel) throws IOException {
        this.myConnectionListener.onError(channel, new SocketTimeoutException());
    }
}

