/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.network;

import com.turn.ttorrent.network.ConnectionListener;
import com.turn.ttorrent.network.ReadAttachment;
import com.turn.ttorrent.network.TimeoutAttachment;
import com.turn.ttorrent.network.WriteAttachment;
import com.turn.ttorrent.network.WriteTask;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ReadWriteAttachment
implements ReadAttachment,
WriteAttachment,
TimeoutAttachment {
    private static final int WRITE_TASK_QUEUE_SIZE = 150;
    private long lastCommunicationTime;
    private final ConnectionListener connectionListener;
    private final long myTimeoutMillis;
    private final BlockingQueue<WriteTask> writeTasks;

    public ReadWriteAttachment(ConnectionListener connectionListener, long lastCommunicationTime, long timeoutMillis) {
        this.connectionListener = connectionListener;
        this.writeTasks = new LinkedBlockingQueue<WriteTask>(150);
        this.lastCommunicationTime = lastCommunicationTime;
        this.myTimeoutMillis = timeoutMillis;
    }

    @Override
    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public BlockingQueue<WriteTask> getWriteTasks() {
        return this.writeTasks;
    }

    @Override
    public boolean isTimeoutElapsed(long currentTimeMillis) {
        long minTimeForKeepAlive = currentTimeMillis - this.myTimeoutMillis;
        return minTimeForKeepAlive > this.lastCommunicationTime;
    }

    @Override
    public void communicatedNow(long currentTimeMillis) {
        this.lastCommunicationTime = currentTimeMillis;
    }

    @Override
    public void onTimeoutElapsed(SocketChannel channel) throws IOException {
        this.connectionListener.onError(channel, new SocketTimeoutException());
    }
}

