/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.PeerUID;
import com.turn.ttorrent.common.TorrentHash;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentParser;
import com.turn.ttorrent.common.TorrentUtils;
import com.turn.ttorrent.common.protocol.AnnounceRequestMessage;
import com.turn.ttorrent.tracker.TrackedPeer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

public class TrackedTorrent
implements TorrentHash {
    private static final Logger logger = TorrentLoggerFactory.getLogger(TrackedTorrent.class);
    public static final int MIN_ANNOUNCE_INTERVAL_SECONDS = 5;
    private static final int DEFAULT_ANSWER_NUM_PEERS = 30;
    private static final int DEFAULT_ANNOUNCE_INTERVAL_SECONDS = 10;
    private int answerPeers;
    private int announceInterval;
    private final byte[] info_hash;
    private ConcurrentMap<PeerUID, TrackedPeer> peers;

    public TrackedTorrent(byte[] info_hash) {
        this.info_hash = info_hash;
        this.peers = new ConcurrentHashMap<PeerUID, TrackedPeer>();
        this.answerPeers = 30;
        this.announceInterval = 10;
    }

    public Map<PeerUID, TrackedPeer> getPeers() {
        return this.peers;
    }

    public void addPeer(TrackedPeer peer) {
        this.peers.put(new PeerUID(peer.getAddress(), this.getHexInfoHash()), peer);
    }

    public TrackedPeer getPeer(PeerUID peerUID) {
        return (TrackedPeer)this.peers.get(peerUID);
    }

    public TrackedPeer removePeer(PeerUID peerUID) {
        return (TrackedPeer)this.peers.remove(peerUID);
    }

    public int seeders() {
        int count = 0;
        for (TrackedPeer peer : this.peers.values()) {
            if (!peer.isCompleted()) continue;
            ++count;
        }
        return count;
    }

    public int leechers() {
        int count = 0;
        for (TrackedPeer peer : this.peers.values()) {
            if (peer.isCompleted()) continue;
            ++count;
        }
        return count;
    }

    public void collectUnfreshPeers(int expireTimeoutSec) {
        for (TrackedPeer peer : this.peers.values()) {
            if (peer.isFresh(expireTimeoutSec)) continue;
            this.peers.remove(new PeerUID(peer.getAddress(), this.getHexInfoHash()));
        }
    }

    public int getAnnounceInterval() {
        return this.announceInterval;
    }

    public void setAnnounceInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Invalid announce interval");
        }
        this.announceInterval = interval;
    }

    public TrackedPeer update(AnnounceRequestMessage.RequestEvent event, ByteBuffer peerId, String hexPeerId, String ip, int port, long uploaded, long downloaded, long left) throws UnsupportedEncodingException {
        logger.trace("event {}, Peer: {}:{}", new Object[]{event.getEventName(), ip, port});
        TrackedPeer peer = null;
        TrackedPeer.PeerState state = TrackedPeer.PeerState.UNKNOWN;
        PeerUID peerUID = new PeerUID(new InetSocketAddress(ip, port), this.getHexInfoHash());
        if (AnnounceRequestMessage.RequestEvent.STARTED.equals((Object)event)) {
            state = TrackedPeer.PeerState.STARTED;
        } else if (AnnounceRequestMessage.RequestEvent.STOPPED.equals((Object)event)) {
            peer = this.removePeer(peerUID);
            state = TrackedPeer.PeerState.STOPPED;
        } else if (AnnounceRequestMessage.RequestEvent.COMPLETED.equals((Object)event)) {
            peer = this.getPeer(peerUID);
            state = TrackedPeer.PeerState.COMPLETED;
        } else if (AnnounceRequestMessage.RequestEvent.NONE.equals((Object)event)) {
            peer = this.getPeer(peerUID);
            state = TrackedPeer.PeerState.STARTED;
        } else {
            throw new IllegalArgumentException("Unexpected announce event type!");
        }
        if (peer == null) {
            peer = new TrackedPeer(this, ip, port, peerId);
            this.addPeer(peer);
        }
        peer.update(state, uploaded, downloaded, left);
        return peer;
    }

    public List<Peer> getSomePeers(Peer peer) {
        LinkedList<Peer> peers = new LinkedList<Peer>();
        LinkedList candidates = new LinkedList(this.peers.values());
        Collections.shuffle(candidates);
        int count = 0;
        for (TrackedPeer candidate : candidates) {
            if (peer != null && peer.looksLike(candidate)) continue;
            if (count++ > this.answerPeers) break;
            peers.add(candidate);
        }
        return peers;
    }

    public static TrackedTorrent load(File torrent) throws IOException {
        TorrentMetadata torrentMetadata = new TorrentParser().parseFromFile(torrent);
        return new TrackedTorrent(torrentMetadata.getInfoHash());
    }

    @Override
    public byte[] getInfoHash() {
        return this.info_hash;
    }

    @Override
    public String getHexInfoHash() {
        return TorrentUtils.byteArrayToHexString(this.info_hash);
    }

    public String toString() {
        return "TrackedTorrent{info_hash=" + this.getHexInfoHash() + '}';
    }
}

