/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.bcodec.BDecoder;
import com.turn.ttorrent.bcodec.BEncoder;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.protocol.http.HTTPTrackerErrorMessage;
import com.turn.ttorrent.tracker.TrackerRequestProcessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simpleframework.http.Status;
import org.slf4j.Logger;

public class MultiAnnounceRequestProcessor {
    private final TrackerRequestProcessor myTrackerRequestProcessor;
    private static final Logger logger = TorrentLoggerFactory.getLogger(MultiAnnounceRequestProcessor.class);

    public MultiAnnounceRequestProcessor(TrackerRequestProcessor trackerRequestProcessor) {
        this.myTrackerRequestProcessor = trackerRequestProcessor;
    }

    public void process(String body, String url, String hostAddress, TrackerRequestProcessor.RequestHandler requestHandler) throws IOException {
        final ArrayList responseMessages = new ArrayList();
        final AtomicBoolean isAnySuccess = new AtomicBoolean(false);
        for (String s : body.split("\n")) {
            this.myTrackerRequestProcessor.process(s, hostAddress, new TrackerRequestProcessor.RequestHandler(){

                @Override
                public void serveResponse(int code, String description, ByteBuffer responseData) {
                    isAnySuccess.set(isAnySuccess.get() || code == Status.OK.getCode());
                    try {
                        responseMessages.add(BDecoder.bdecode((ByteBuffer)responseData));
                    }
                    catch (IOException e) {
                        logger.warn("cannot decode message from byte buffer");
                    }
                }
            });
        }
        if (responseMessages.isEmpty()) {
            ByteBuffer res = HTTPTrackerErrorMessage.craft("").getData();
            Status status = Status.BAD_REQUEST;
            requestHandler.serveResponse(status.getCode(), "", res);
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BEncoder.bencode(responseMessages, (OutputStream)out);
        requestHandler.serveResponse(isAnySuccess.get() ? Status.OK.getCode() : Status.BAD_REQUEST.getCode(), "", ByteBuffer.wrap(out.toByteArray()));
    }
}

