/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.common.protocol.AnnounceRequestMessage;
import com.turn.ttorrent.tracker.TrackedTorrent;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class TorrentsRepository {
    private final ReentrantLock[] myLocks;
    private final ConcurrentMap<String, TrackedTorrent> myTorrents;

    public TorrentsRepository(int locksCount) {
        if (locksCount <= 0) {
            throw new IllegalArgumentException("Lock count must be positive");
        }
        this.myLocks = new ReentrantLock[locksCount];
        for (int i = 0; i < this.myLocks.length; ++i) {
            this.myLocks[i] = new ReentrantLock();
        }
        this.myTorrents = new ConcurrentHashMap<String, TrackedTorrent>();
    }

    public TrackedTorrent getTorrent(String hexInfoHash) {
        return (TrackedTorrent)this.myTorrents.get(hexInfoHash);
    }

    public void putIfAbsent(String hexInfoHash, TrackedTorrent torrent) {
        this.myTorrents.putIfAbsent(hexInfoHash, torrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackedTorrent putIfAbsentAndUpdate(String hexInfoHash, TrackedTorrent torrent, AnnounceRequestMessage.RequestEvent event, ByteBuffer peerId, String hexPeerId, String ip, int port, long uploaded, long downloaded, long left) throws UnsupportedEncodingException {
        TrackedTorrent actualTorrent;
        try {
            this.lockFor(hexInfoHash).lock();
            TrackedTorrent oldTorrent = this.myTorrents.putIfAbsent(hexInfoHash, torrent);
            actualTorrent = oldTorrent == null ? torrent : oldTorrent;
            actualTorrent.update(event, peerId, hexPeerId, ip, port, uploaded, downloaded, left);
        }
        finally {
            this.lockFor(hexInfoHash).unlock();
        }
        return actualTorrent;
    }

    private ReentrantLock lockFor(String torrentHash) {
        return this.myLocks[Math.abs(torrentHash.hashCode()) % this.myLocks.length];
    }

    public void clear() {
        this.myTorrents.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(int torrentExpireTimeoutSec) {
        for (TrackedTorrent trackedTorrent : this.myTorrents.values()) {
            try {
                this.lockFor(trackedTorrent.getHexInfoHash()).lock();
                trackedTorrent.collectUnfreshPeers(torrentExpireTimeoutSec);
                if (trackedTorrent.getPeers().size() != 0) continue;
                this.myTorrents.remove(trackedTorrent.getHexInfoHash());
            }
            finally {
                this.lockFor(trackedTorrent.getHexInfoHash()).unlock();
            }
        }
    }

    public Map<String, TrackedTorrent> getTorrents() {
        return new HashMap<String, TrackedTorrent>(this.myTorrents);
    }
}

