/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.SystemTimeService;
import com.turn.ttorrent.common.TimeService;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.tracker.TrackedTorrent;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.slf4j.Logger;

public class TrackedPeer
extends Peer {
    private static final Logger logger = TorrentLoggerFactory.getLogger(TrackedPeer.class);
    private final TimeService myTimeService;
    private long uploaded;
    private long downloaded;
    private long left;
    private TrackedTorrent torrent;
    private PeerState state;
    private long lastAnnounce;

    public TrackedPeer(TrackedTorrent torrent, String ip, int port, ByteBuffer peerId) {
        this(torrent, ip, port, peerId, new SystemTimeService());
    }

    TrackedPeer(TrackedTorrent torrent, String ip, int port, ByteBuffer peerId, TimeService timeService) {
        super(ip, port, peerId);
        this.myTimeService = timeService;
        this.torrent = torrent;
        this.state = PeerState.UNKNOWN;
        this.lastAnnounce = this.myTimeService.now();
        this.uploaded = 0L;
        this.downloaded = 0L;
        this.left = 0L;
    }

    public void update(PeerState state, long uploaded, long downloaded, long left) {
        if (PeerState.STARTED.equals((Object)state) && left == 0L) {
            state = PeerState.COMPLETED;
        }
        if (!state.equals((Object)this.state)) {
            logger.trace("Peer {} {} download of {}.", new Object[]{this, state.name().toLowerCase(), this.torrent});
        }
        this.state = state;
        this.lastAnnounce = this.myTimeService.now();
        this.uploaded = uploaded;
        this.downloaded = downloaded;
        this.left = left;
    }

    public boolean isCompleted() {
        return PeerState.COMPLETED.equals((Object)this.state);
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getLeft() {
        return this.left;
    }

    public boolean isFresh(int expireTimeoutSec) {
        return this.lastAnnounce + (long)(expireTimeoutSec * 1000) > this.myTimeService.now();
    }

    public BEValue toBEValue() throws UnsupportedEncodingException {
        HashMap<String, BEValue> peer = new HashMap<String, BEValue>();
        if (this.hasPeerId()) {
            peer.put("peer id", new BEValue(this.getPeerIdArray()));
        }
        peer.put("ip", new BEValue(this.getIp(), "ISO-8859-1"));
        peer.put("port", new BEValue(this.getPort()));
        return new BEValue(peer);
    }

    public static enum PeerState {
        UNKNOWN,
        STARTED,
        COMPLETED,
        STOPPED;

    }
}

