/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;

public class TempFiles {
    private static final File ourCurrentTempDir = FileUtils.getTempDirectory();
    private final File myCurrentTempDir;
    private static Random ourRandom = new Random();
    private final List<File> myFilesToDelete = new ArrayList<File>();
    private final Thread myShutdownHook;
    private volatile boolean myInsideShutdownHook;

    public TempFiles() {
        this.myCurrentTempDir = ourCurrentTempDir;
        if (!this.myCurrentTempDir.isDirectory()) {
            throw new IllegalStateException("Temp directory is not a directory, was deleted by some process: " + this.myCurrentTempDir.getAbsolutePath() + "\njava.io.tmpdir: " + FileUtils.getTempDirectory());
        }
        this.myShutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                TempFiles.this.myInsideShutdownHook = true;
                TempFiles.this.cleanup();
            }
        });
        Runtime.getRuntime().addShutdownHook(this.myShutdownHook);
    }

    private File doCreateTempDir(String prefix, String suffix) throws IOException {
        int count;
        File f;
        prefix = prefix == null ? "" : prefix;
        suffix = suffix == null ? ".tmp" : suffix;
        do {
            count = ourRandom.nextInt();
        } while ((f = new File(this.myCurrentTempDir, prefix + count + suffix)).exists() || !f.mkdirs());
        return f.getCanonicalFile();
    }

    private File doCreateTempFile(String prefix, String suffix) throws IOException {
        File file = this.doCreateTempDir(prefix, suffix);
        file.delete();
        file.createNewFile();
        return file;
    }

    public final File createTempFile() throws IOException {
        File tempFile = this.doCreateTempFile("test", null);
        this.registerAsTempFile(tempFile);
        return tempFile;
    }

    public void registerAsTempFile(File tempFile) {
        this.myFilesToDelete.add(tempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File createTempFile(int size) throws IOException {
        File tempFile = this.createTempFile();
        int bufLen = Math.min(8192, size);
        Random random = new Random();
        if (bufLen == 0) {
            return tempFile;
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(tempFile));
        try {
            byte[] buf = new byte[bufLen];
            int numWritten = 0;
            for (int i = 0; i < size / buf.length; ++i) {
                random.nextBytes(buf);
                ((OutputStream)fos).write(buf);
                numWritten += buf.length;
            }
            if (size > numWritten) {
                random.nextBytes(buf);
                ((OutputStream)fos).write(buf, 0, size - numWritten);
            }
        }
        finally {
            ((OutputStream)fos).close();
        }
        return tempFile;
    }

    public final File createTempDir() throws IOException {
        File f = this.doCreateTempDir("test", "");
        this.registerAsTempFile(f);
        return f;
    }

    public File getCurrentTempDir() {
        return this.myCurrentTempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            for (File file : this.myFilesToDelete) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException iOException) {}
            }
            this.myFilesToDelete.clear();
        }
        finally {
            if (!this.myInsideShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.myShutdownHook);
            }
        }
    }

    static {
        ourRandom.setSeed(System.currentTimeMillis());
    }
}

