/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common;

import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.BEncoder;
import com.turn.ttorrent.common.Optional;
import com.turn.ttorrent.common.TorrentFile;
import com.turn.ttorrent.common.TorrentMetadata;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TorrentSerializer {
    public byte[] serialize(TorrentMetadata metadata) throws IOException {
        List<BEValue> announceList;
        HashMap<String, BEValue> mapMetadata = new HashMap<String, BEValue>();
        HashMap<String, BEValue> infoTable = new HashMap<String, BEValue>();
        String announce = metadata.getAnnounce();
        if (announce != null) {
            mapMetadata.put("announce", new BEValue(announce));
        }
        this.putOptionalIfPresent(mapMetadata, "comment", metadata.getComment());
        this.putOptionalIfPresent(mapMetadata, "created by", metadata.getCreatedBy());
        if (metadata.getCreationDate().isPresent()) {
            mapMetadata.put("creation date", new BEValue((Number)metadata.getCreationDate().get()));
        }
        if ((announceList = this.getAnnounceListAsBEValues(metadata.getAnnounceList())) != null) {
            mapMetadata.put("announce-list", new BEValue(announceList));
        }
        infoTable.put("piece length", new BEValue(metadata.getPieceLength()));
        infoTable.put("pieces", new BEValue(metadata.getPiecesHashes()));
        if (metadata.isPrivate()) {
            infoTable.put("private", new BEValue(1));
        }
        infoTable.put("name", new BEValue(metadata.getDirectoryName()));
        if (metadata.getFiles().size() == 1) {
            TorrentFile torrentFile = metadata.getFiles().get(0);
            infoTable.put("length", new BEValue(torrentFile.size));
            this.putOptionalIfPresent(infoTable, "md5sum", torrentFile.md5Hash);
        } else {
            ArrayList<BEValue> files = new ArrayList<BEValue>();
            for (TorrentFile torrentFile : metadata.getFiles()) {
                HashMap<String, BEValue> entry = new HashMap<String, BEValue>();
                entry.put("length", new BEValue(torrentFile.size));
                this.putOptionalIfPresent(entry, "md5sum", torrentFile.md5Hash);
                entry.put("path", new BEValue(this.mapStringListToBEValueList(torrentFile.relativePath)));
                files.add(new BEValue(entry));
            }
            infoTable.put("files", new BEValue(files));
        }
        mapMetadata.put("info", new BEValue(infoTable));
        ByteBuffer buffer = BEncoder.bencode(mapMetadata);
        return buffer.array();
    }

    @Nullable
    private List<BEValue> getAnnounceListAsBEValues(@Nullable List<List<String>> announceList) throws UnsupportedEncodingException {
        if (announceList == null) {
            return null;
        }
        ArrayList<BEValue> result = new ArrayList<BEValue>();
        for (List<String> announceTier : announceList) {
            List<BEValue> tier = this.mapStringListToBEValueList(announceTier);
            if (tier.isEmpty()) continue;
            result.add(new BEValue(tier));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private List<BEValue> mapStringListToBEValueList(List<String> list) throws UnsupportedEncodingException {
        ArrayList<BEValue> result = new ArrayList<BEValue>();
        for (String s : list) {
            result.add(new BEValue(s));
        }
        return result;
    }

    private void putOptionalIfPresent(Map<String, BEValue> map, String key, Optional<String> optional) throws UnsupportedEncodingException {
        if (!optional.isPresent()) {
            return;
        }
        map.put(key, new BEValue(optional.get()));
    }
}

