/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol.http;

import com.turn.ttorrent.Constants;
import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.BEncoder;
import com.turn.ttorrent.bcodec.InvalidBEncodingException;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.http.HTTPTrackerMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class HTTPTrackerErrorMessage
extends HTTPTrackerMessage
implements TrackerMessage.ErrorMessage {
    private final String reason;

    private HTTPTrackerErrorMessage(ByteBuffer data, String reason) {
        super(TrackerMessage.Type.ERROR, data);
        this.reason = reason;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public static HTTPTrackerErrorMessage parse(BEValue decoded) throws IOException, TrackerMessage.MessageValidationException {
        if (decoded == null) {
            throw new TrackerMessage.MessageValidationException("Could not decode tracker message (not B-encoded?)!");
        }
        Map params = decoded.getMap();
        try {
            return new HTTPTrackerErrorMessage(Constants.EMPTY_BUFFER, ((BEValue)params.get("failure reason")).getString("ISO-8859-1"));
        }
        catch (InvalidBEncodingException ibee) {
            throw new TrackerMessage.MessageValidationException("Invalid tracker error message!", ibee);
        }
    }

    public static HTTPTrackerErrorMessage craft(TrackerMessage.ErrorMessage.FailureReason reason) throws IOException {
        return HTTPTrackerErrorMessage.craft(reason.getMessage());
    }

    public static HTTPTrackerErrorMessage craft(String reason) throws IOException {
        HashMap<String, BEValue> params = new HashMap<String, BEValue>();
        params.put("failure reason", new BEValue(reason, "ISO-8859-1"));
        return new HTTPTrackerErrorMessage(BEncoder.bencode(params), reason);
    }
}

