/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol.udp;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.udp.UDPTrackerMessage;
import java.nio.ByteBuffer;

public class UDPConnectRequestMessage
extends UDPTrackerMessage.UDPTrackerRequestMessage
implements TrackerMessage.ConnectionRequestMessage {
    private static final int UDP_CONNECT_REQUEST_MESSAGE_SIZE = 16;
    private static final long UDP_CONNECT_REQUEST_MAGIC = 4497486125440L;
    private final long connectionId = 4497486125440L;
    private final int actionId = TrackerMessage.Type.CONNECT_REQUEST.getId();
    private final int transactionId;

    private UDPConnectRequestMessage(ByteBuffer data, int transactionId) {
        super(TrackerMessage.Type.CONNECT_REQUEST, data);
        this.transactionId = transactionId;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    @Override
    public int getActionId() {
        return this.actionId;
    }

    @Override
    public int getTransactionId() {
        return this.transactionId;
    }

    public static UDPConnectRequestMessage parse(ByteBuffer data) throws TrackerMessage.MessageValidationException {
        if (data.remaining() != 16) {
            throw new TrackerMessage.MessageValidationException("Invalid connect request message size!");
        }
        if (data.getLong() != 4497486125440L) {
            throw new TrackerMessage.MessageValidationException("Invalid connection ID in connection request!");
        }
        if (data.getInt() != TrackerMessage.Type.CONNECT_REQUEST.getId()) {
            throw new TrackerMessage.MessageValidationException("Invalid action code for connection request!");
        }
        return new UDPConnectRequestMessage(data, data.getInt());
    }

    public static UDPConnectRequestMessage craft(int transactionId) {
        ByteBuffer data = ByteBuffer.allocate(16);
        data.putLong(4497486125440L);
        data.putInt(TrackerMessage.Type.CONNECT_REQUEST.getId());
        data.putInt(transactionId);
        return new UDPConnectRequestMessage(data, transactionId);
    }
}

