/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.CommunicationManager;
import com.turn.ttorrent.client.FileMetadataProvider;
import com.turn.ttorrent.client.LoadedTorrent;
import com.turn.ttorrent.client.TorrentListener;
import com.turn.ttorrent.client.TorrentListenerWrapper;
import com.turn.ttorrent.client.TorrentManager;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentStatistic;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SimpleClient {
    private static final int DEFAULT_EXECUTOR_SIZE = 10;
    private final CommunicationManager communicationManager;

    public SimpleClient() {
        this(10, 10);
    }

    public SimpleClient(int workingExecutorSize, int validatorExecutorSize) {
        this.communicationManager = new CommunicationManager(Executors.newFixedThreadPool(workingExecutorSize), Executors.newFixedThreadPool(validatorExecutorSize));
    }

    public void stop() {
        this.stop(60, TimeUnit.SECONDS);
    }

    public void stop(int timeout, TimeUnit timeUnit) {
        this.communicationManager.stop(timeout, timeUnit);
        InterruptedException interruptedException = null;
        boolean anyFailedByTimeout = false;
        for (ExecutorService executorService : Arrays.asList(this.communicationManager.getExecutor(), this.communicationManager.getPieceValidatorExecutor())) {
            executorService.shutdown();
            if (Thread.currentThread().isInterrupted()) continue;
            try {
                if (executorService.awaitTermination(timeout, timeUnit)) continue;
                anyFailedByTimeout = true;
            }
            catch (InterruptedException e) {
                interruptedException = e;
            }
        }
        if (interruptedException != null) {
            throw new RuntimeException("Thread was interrupted, shutdown methods are invoked but maybe tasks are not finished yet", interruptedException);
        }
        if (anyFailedByTimeout) {
            throw new RuntimeException("At least one executor was not fully shutdown because timeout was elapsed");
        }
    }

    public void downloadTorrent(String torrentFile, String downloadDir, InetAddress iPv4Address) throws IOException, InterruptedException {
        this.communicationManager.start(iPv4Address);
        final Semaphore semaphore = new Semaphore(0);
        List<TorrentListener> listeners = Collections.singletonList(new TorrentListenerWrapper(){

            @Override
            public void validationComplete(int validpieces, int totalpieces) {
                if (validpieces == totalpieces) {
                    semaphore.release();
                }
            }

            @Override
            public void downloadComplete() {
                semaphore.release();
            }
        });
        TorrentManager torrentManager = this.communicationManager.addTorrent(torrentFile, downloadDir, listeners);
        semaphore.acquire();
    }

    private TorrentManager startDownloading(String torrentFile, String downloadDir, InetAddress iPv4Address) throws IOException {
        this.communicationManager.start(iPv4Address);
        return this.communicationManager.addTorrent(torrentFile, downloadDir);
    }

    public TorrentManager downloadTorrentAsync(String torrentFile, String downloadDir, InetAddress iPv4Address) throws IOException {
        return this.startDownloading(torrentFile, downloadDir, iPv4Address);
    }

    public TorrentStatistic getStatistics(String dotTorrentFilePath) throws IOException {
        FileMetadataProvider metadataProvider = new FileMetadataProvider(dotTorrentFilePath);
        TorrentMetadata metadata = metadataProvider.getTorrentMetadata();
        LoadedTorrent loadedTorrent = this.communicationManager.getTorrentsStorage().getLoadedTorrent(metadata.getHexInfoHash());
        if (loadedTorrent != null) {
            return new TorrentStatistic(loadedTorrent.getTorrentStatistic());
        }
        throw new IllegalStateException("Torrent has not been loaded yet");
    }

    public boolean hasStop() {
        return this.communicationManager.hasStop();
    }
}

