/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.LoadedTorrent;
import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.TorrentLoader;
import com.turn.ttorrent.client.TorrentsStorage;
import com.turn.ttorrent.client.strategy.RequestStrategyImplAnyInteresting;
import com.turn.ttorrent.common.TorrentMetadata;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class TorrentLoaderImpl
implements TorrentLoader {
    @NotNull
    private final TorrentsStorage myTorrentsStorage;

    public TorrentLoaderImpl(@NotNull TorrentsStorage torrentsStorage) {
        this.myTorrentsStorage = torrentsStorage;
    }

    @Override
    @NotNull
    public SharedTorrent loadTorrent(@NotNull LoadedTorrent loadedTorrent) throws IOException {
        TorrentMetadata torrentMetadata;
        String hexInfoHash = loadedTorrent.getTorrentHash().getHexInfoHash();
        SharedTorrent old = this.myTorrentsStorage.getTorrent(hexInfoHash);
        if (old != null) {
            return old;
        }
        try {
            torrentMetadata = loadedTorrent.getMetadata();
        }
        catch (IllegalStateException e) {
            this.myTorrentsStorage.remove(hexInfoHash);
            throw e;
        }
        SharedTorrent sharedTorrent = new SharedTorrent(torrentMetadata, loadedTorrent.getPieceStorage(), new RequestStrategyImplAnyInteresting(), loadedTorrent.getTorrentStatistic(), loadedTorrent.getEventDispatcher());
        old = this.myTorrentsStorage.putIfAbsentActiveTorrent(hexInfoHash, sharedTorrent);
        if (old != null) {
            return old;
        }
        return sharedTorrent;
    }
}

