/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.announce;

import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.client.announce.AnnounceResponseListener;
import com.turn.ttorrent.common.AnnounceableInformation;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.protocol.AnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.AnnounceResponseMessage;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.net.ConnectException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public abstract class TrackerClient {
    private static final Logger logger = TorrentLoggerFactory.getLogger(TrackerClient.class);
    private final Set<AnnounceResponseListener> listeners = new HashSet<AnnounceResponseListener>();
    protected final List<Peer> myAddress;
    protected final URI tracker;

    public TrackerClient(List<Peer> peers, URI tracker) {
        this.myAddress = peers;
        this.tracker = tracker;
    }

    public void register(AnnounceResponseListener listener) {
        this.listeners.add(listener);
    }

    public URI getTrackerURI() {
        return this.tracker;
    }

    public void announceAllInterfaces(AnnounceRequestMessage.RequestEvent event, boolean inhibitEvent, AnnounceableInformation torrent) throws AnnounceException {
        try {
            this.announce(event, inhibitEvent, torrent, this.myAddress);
        }
        catch (AnnounceException e) {
            throw new AnnounceException(String.format("Unable to announce tracker %s event %s for torrent %s and peers %s. Reason %s", this.getTrackerURI(), event.getEventName(), torrent.getHexInfoHash(), Arrays.toString(this.myAddress.toArray()), e.getMessage()), e);
        }
    }

    protected abstract void announce(AnnounceRequestMessage.RequestEvent var1, boolean var2, AnnounceableInformation var3, List<Peer> var4) throws AnnounceException;

    protected abstract void multiAnnounce(AnnounceRequestMessage.RequestEvent var1, boolean var2, List<? extends AnnounceableInformation> var3, List<Peer> var4) throws AnnounceException, ConnectException;

    protected void logAnnounceRequest(AnnounceRequestMessage.RequestEvent event, AnnounceableInformation torrent) {
        if (event != AnnounceRequestMessage.RequestEvent.NONE) {
            logger.debug("Announcing {} to tracker with {}U/{}D/{}L bytes...", new Object[]{this.formatAnnounceEvent(event), torrent.getUploaded(), torrent.getDownloaded(), torrent.getLeft()});
        } else {
            logger.debug("Simply announcing to tracker with {}U/{}D/{}L bytes...", new Object[]{torrent.getUploaded(), torrent.getDownloaded(), torrent.getLeft()});
        }
    }

    protected void close() {
    }

    protected String formatAnnounceEvent(AnnounceRequestMessage.RequestEvent event) {
        return AnnounceRequestMessage.RequestEvent.NONE.equals((Object)event) ? "" : String.format(" %s", event.name());
    }

    protected void handleTrackerAnnounceResponse(TrackerMessage message, boolean inhibitEvents, String hexInfoHash) throws AnnounceException {
        if (message instanceof TrackerMessage.ErrorMessage) {
            TrackerMessage.ErrorMessage error = (TrackerMessage.ErrorMessage)message;
            throw new AnnounceException(error.getReason());
        }
        if (!(message instanceof AnnounceResponseMessage)) {
            throw new AnnounceException("Unexpected tracker message type " + message.getType().name() + "!");
        }
        AnnounceResponseMessage response = (AnnounceResponseMessage)message;
        this.fireAnnounceResponseEvent(response.getComplete(), response.getIncomplete(), response.getInterval(), hexInfoHash);
        if (inhibitEvents) {
            return;
        }
        this.fireDiscoveredPeersEvent(response.getPeers(), hexInfoHash);
    }

    protected void fireAnnounceResponseEvent(int complete, int incomplete, int interval, String hexInfoHash) {
        for (AnnounceResponseListener listener : this.listeners) {
            listener.handleAnnounceResponse(interval, complete, incomplete, hexInfoHash);
        }
    }

    protected void fireDiscoveredPeersEvent(List<Peer> peers, String hexInfoHash) {
        for (AnnounceResponseListener listener : this.listeners) {
            listener.handleDiscoveredPeers(peers, hexInfoHash);
        }
    }
}

