/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.network;

import com.turn.ttorrent.client.Context;
import com.turn.ttorrent.client.Handshake;
import com.turn.ttorrent.client.LoadedTorrent;
import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.network.DataProcessor;
import com.turn.ttorrent.client.network.ShutdownAndRemovePeerProcessor;
import com.turn.ttorrent.client.network.ShutdownProcessor;
import com.turn.ttorrent.client.network.WorkingReceiver;
import com.turn.ttorrent.client.peer.SharingPeer;
import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.PeerUID;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.text.ParseException;
import java.util.Arrays;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;

public class HandshakeReceiver
implements DataProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(HandshakeReceiver.class);
    private final Context myContext;
    private final String myHostAddress;
    private final int myPort;
    private final boolean myIsOutgoingConnection;
    private ByteBuffer messageBytes;
    private int pstrLength;

    HandshakeReceiver(Context context, String hostAddress, int port, boolean isOutgoingListener) {
        this.myContext = context;
        this.myHostAddress = hostAddress;
        this.myPort = port;
        this.pstrLength = -1;
        this.myIsOutgoingConnection = isOutgoingListener;
    }

    @Override
    public DataProcessor processAndGetNext(ByteChannel socketChannel) throws IOException {
        SharedTorrent torrent;
        if (this.pstrLength == -1) {
            ByteBuffer len = ByteBuffer.allocate(1);
            int readBytes = -1;
            try {
                readBytes = socketChannel.read(len);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (readBytes == -1) {
                return new ShutdownProcessor().processAndGetNext(socketChannel);
            }
            if (readBytes == 0) {
                return this;
            }
            len.rewind();
            byte pstrLen = len.get();
            this.pstrLength = pstrLen;
            this.messageBytes = ByteBuffer.allocate(this.pstrLength + 49);
            this.messageBytes.put(pstrLen);
        }
        int readBytes = -1;
        try {
            readBytes = socketChannel.read(this.messageBytes);
        }
        catch (IOException e) {
            LoggerUtils.warnAndDebugDetails((Logger)logger, (String)"unable to read data from {}", (Object)socketChannel, (Throwable)e);
        }
        if (readBytes == -1) {
            return new ShutdownProcessor().processAndGetNext(socketChannel);
        }
        if (this.messageBytes.remaining() != 0) {
            return this;
        }
        Handshake hs = this.parseHandshake(socketChannel.toString());
        if (hs == null) {
            return new ShutdownProcessor().processAndGetNext(socketChannel);
        }
        LoadedTorrent announceableTorrent = this.myContext.getTorrentsStorage().getLoadedTorrent(hs.getHexInfoHash());
        if (announceableTorrent == null) {
            logger.debug("Announceable torrent {} is not found in storage", (Object)hs.getHexInfoHash());
            return new ShutdownProcessor().processAndGetNext(socketChannel);
        }
        try {
            torrent = this.myContext.getTorrentLoader().loadTorrent(announceableTorrent);
        }
        catch (IllegalStateException e) {
            return new ShutdownProcessor().processAndGetNext(socketChannel);
        }
        catch (Exception e) {
            LoggerUtils.warnWithMessageAndDebugDetails((Logger)logger, (String)"cannot load torrent {}", (Object)hs.getHexInfoHash(), (Throwable)e);
            return new ShutdownProcessor().processAndGetNext(socketChannel);
        }
        logger.trace("got handshake {} from {}", (Object)Arrays.toString(this.messageBytes.array()), (Object)socketChannel);
        String clientTypeVersion = new String(Arrays.copyOf(hs.getPeerId(), 8));
        String clientType = clientTypeVersion.substring(1, 3);
        int clientVersion = 0;
        try {
            clientVersion = Integer.parseInt(clientTypeVersion.substring(3, 7));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        final SharingPeer sharingPeer = this.myContext.createSharingPeer(this.myHostAddress, this.myPort, ByteBuffer.wrap(hs.getPeerId()), torrent, socketChannel, clientType, clientVersion);
        PeerUID peerUID = new PeerUID(sharingPeer.getAddress(), hs.getHexInfoHash());
        SharingPeer old = this.myContext.getPeersStorage().putIfAbsent(peerUID, sharingPeer);
        if (old != null) {
            logger.debug("Already connected to old peer {}, close current connection with {}", (Object)old, (Object)sharingPeer);
            return new ShutdownProcessor().processAndGetNext(socketChannel);
        }
        if (!this.myIsOutgoingConnection) {
            logger.trace("send handshake to {}", (Object)socketChannel);
            try {
                Handshake craft = Handshake.craft(hs.getInfoHash(), this.myContext.getPeersStorage().getSelf().getPeerIdArray());
                socketChannel.write(craft.getData());
            }
            catch (IOException e) {
                LoggerUtils.warnAndDebugDetails((Logger)logger, (String)"error in sending handshake to {}", (Object)socketChannel, (Throwable)e);
                return new ShutdownAndRemovePeerProcessor(peerUID, this.myContext);
            }
        }
        logger.debug("setup new connection with {}", (Object)sharingPeer);
        try {
            this.myContext.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        sharingPeer.onConnectionEstablished();
                    }
                    catch (Throwable e) {
                        LoggerUtils.warnAndDebugDetails((Logger)logger, (String)"unhandled exception {} in executor task (onConnectionEstablished)", (Object)e.toString(), (Throwable)e);
                    }
                }
            });
            torrent.addConnectedPeer(sharingPeer);
        }
        catch (RejectedExecutionException e) {
            LoggerUtils.warnAndDebugDetails((Logger)logger, (String)"task 'onConnectionEstablished' submit is failed. Reason: {}", (Object)e.getMessage(), (Throwable)e);
            return new ShutdownAndRemovePeerProcessor(peerUID, this.myContext).processAndGetNext(socketChannel);
        }
        return new WorkingReceiver(peerUID, this.myContext);
    }

    private Handshake parseHandshake(String socketChannelForLog) throws IOException {
        try {
            this.messageBytes.rewind();
            return Handshake.parse(this.messageBytes, this.pstrLength);
        }
        catch (ParseException e) {
            logger.info("incorrect handshake message from " + socketChannelForLog, (Throwable)e);
            return null;
        }
    }

    @Override
    public DataProcessor handleError(ByteChannel socketChannel, Throwable e) throws IOException {
        return new ShutdownProcessor().processAndGetNext(socketChannel);
    }
}

