/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.network;

import com.turn.ttorrent.client.Context;
import com.turn.ttorrent.client.Handshake;
import com.turn.ttorrent.client.network.DataProcessor;
import com.turn.ttorrent.client.network.HandshakeReceiver;
import com.turn.ttorrent.client.network.ShutdownProcessor;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.TorrentHash;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Arrays;
import org.slf4j.Logger;

public class HandshakeSender
implements DataProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(HandshakeSender.class);
    private final TorrentHash myTorrentHash;
    private final String myRemotePeerIp;
    private final int myRemotePeerPort;
    private final Context myContext;

    public HandshakeSender(TorrentHash torrentHash, String remotePeerIp, int remotePeerPort, Context context) {
        this.myTorrentHash = torrentHash;
        this.myRemotePeerIp = remotePeerIp;
        this.myRemotePeerPort = remotePeerPort;
        this.myContext = context;
    }

    @Override
    public DataProcessor processAndGetNext(ByteChannel socketChannel) throws IOException {
        Peer self = this.myContext.getPeersStorage().getSelf();
        Handshake handshake = Handshake.craft(this.myTorrentHash.getInfoHash(), self.getPeerIdArray());
        if (handshake == null) {
            logger.warn("can not craft handshake message. Self peer id is {}, torrent hash is {}", (Object)Arrays.toString(self.getPeerIdArray()), (Object)Arrays.toString(this.myTorrentHash.getInfoHash()));
            return new ShutdownProcessor();
        }
        ByteBuffer messageToSend = ByteBuffer.wrap(handshake.getData().array());
        logger.trace("try send handshake {} to {}", (Object)handshake, (Object)socketChannel);
        while (messageToSend.hasRemaining()) {
            socketChannel.write(messageToSend);
        }
        return new HandshakeReceiver(this.myContext, this.myRemotePeerIp, this.myRemotePeerPort, true);
    }

    @Override
    public DataProcessor handleError(ByteChannel socketChannel, Throwable e) throws IOException {
        return new ShutdownProcessor().processAndGetNext(socketChannel);
    }
}

