/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.network;

import com.turn.ttorrent.client.Context;
import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.network.DataProcessor;
import com.turn.ttorrent.client.network.ShutdownAndRemovePeerProcessor;
import com.turn.ttorrent.client.peer.SharingPeer;
import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.PeerUID;
import com.turn.ttorrent.common.TorrentInfo;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.protocol.PeerMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.text.ParseException;
import java.util.Arrays;
import java.util.concurrent.RejectedExecutionException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class WorkingReceiver
implements DataProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(WorkingReceiver.class);
    private static final int DEF_BUFFER_SIZE = 16;
    private static final int MAX_MESSAGE_SIZE = 0x200000;
    private final PeerUID myPeerUID;
    private final Context myContext;
    @NotNull
    private ByteBuffer messageBytes;
    private int pstrLength;

    WorkingReceiver(PeerUID peerId, Context context) {
        this.myPeerUID = peerId;
        this.myContext = context;
        this.messageBytes = ByteBuffer.allocate(16);
        this.pstrLength = -1;
    }

    @Override
    public DataProcessor processAndGetNext(ByteChannel socketChannel) throws IOException {
        PeerMessage message;
        int readBytes;
        logger.trace("received data from channel", (Object)socketChannel);
        if (this.pstrLength == -1) {
            int read;
            this.messageBytes.limit(4);
            try {
                read = socketChannel.read(this.messageBytes);
            }
            catch (IOException e) {
                logger.debug("unable to read data from channel " + socketChannel, (Throwable)e);
                return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
            }
            if (read < 0) {
                logger.debug("channel {} is closed by other peer", (Object)socketChannel);
                return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
            }
            if (this.messageBytes.hasRemaining()) {
                return this;
            }
            this.pstrLength = this.messageBytes.getInt(0);
            logger.trace("read of message length finished, Message length is {}", (Object)this.pstrLength);
            if (this.pstrLength > 0x200000) {
                logger.warn("Proposed limit of {} is larger than max message size {}", (Object)(4 + this.pstrLength), (Object)0x200000);
                logger.warn("current bytes in buffer is {}", (Object)Arrays.toString(this.messageBytes.array()));
                logger.warn("Close connection with peer {}", (Object)this.myPeerUID);
                return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
            }
        }
        if (4 + this.pstrLength > this.messageBytes.capacity()) {
            ByteBuffer old = this.messageBytes;
            old.rewind();
            this.messageBytes = ByteBuffer.allocate(4 + this.pstrLength);
            this.messageBytes.put(old);
        }
        this.messageBytes.limit(4 + this.pstrLength);
        logger.trace("try read data from {}", (Object)socketChannel);
        try {
            readBytes = socketChannel.read(this.messageBytes);
        }
        catch (IOException e) {
            return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
        }
        if (readBytes < 0) {
            logger.debug("channel {} is closed by other peer", (Object)socketChannel);
            return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
        }
        if (this.messageBytes.hasRemaining()) {
            logger.trace("buffer is not full, continue reading...");
            return this;
        }
        logger.trace("finished read data from {}", (Object)socketChannel);
        this.messageBytes.rewind();
        this.pstrLength = -1;
        final SharingPeer peer = this.myContext.getPeersStorage().getSharingPeer(this.myPeerUID);
        String hexInfoHash = peer.getHexInfoHash();
        SharedTorrent torrent = this.myContext.getTorrentsStorage().getTorrent(hexInfoHash);
        if (torrent == null || !this.myContext.getTorrentsStorage().hasTorrent(hexInfoHash)) {
            logger.debug("torrent with hash {} for peer {} doesn't found in storage. Maybe somebody deletes it manually", (Object)hexInfoHash, (Object)peer);
            return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
        }
        logger.trace("try parse message from {}. Torrent {}", (Object)peer, (Object)torrent);
        ByteBuffer bufferCopy = ByteBuffer.wrap(Arrays.copyOf(this.messageBytes.array(), this.messageBytes.limit()));
        this.messageBytes = ByteBuffer.allocate(16);
        try {
            message = PeerMessage.parse((ByteBuffer)bufferCopy, (TorrentInfo)torrent);
        }
        catch (ParseException e) {
            LoggerUtils.warnAndDebugDetails((Logger)logger, (String)"incorrect message was received from peer {}", (Object)peer, (Throwable)e);
            return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
        }
        logger.trace("get message {} from {}", (Object)message, (Object)socketChannel);
        try {
            this.myContext.getExecutor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    String oldName = currentThread.getName();
                    try {
                        currentThread.setName(oldName + " handle message for torrent " + WorkingReceiver.this.myPeerUID.getTorrentHash() + " peer: " + peer.getHostIdentifier());
                        peer.handleMessage(message);
                    }
                    catch (Throwable e) {
                        LoggerUtils.warnAndDebugDetails((Logger)logger, (String)"unhandled exception {} in executor task (handleMessage)", (Object)e.toString(), (Throwable)e);
                    }
                    finally {
                        currentThread.setName(oldName);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            LoggerUtils.warnAndDebugDetails((Logger)logger, (String)"task submit is failed. Reason: {}", (Object)e.getMessage(), (Throwable)e);
            return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
        }
        return this;
    }

    @Override
    public DataProcessor handleError(ByteChannel socketChannel, Throwable e) throws IOException {
        return new ShutdownAndRemovePeerProcessor(this.myPeerUID, this.myContext).processAndGetNext(socketChannel);
    }
}

